/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.ti89.TITextFileInfo;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class SaveSettingsDialog
extends AppDialog {
    private final JTextField inputFolder = new JTextField();
    private final JTextField inputVariable = new JTextField();
    private final JTextField inputComment = new JTextField();
    private final JPanel picturePanel = new JPanel();
    private final JButtonGroup buttonGroup = new JButtonGroup();
    private JRadioButton radioDontChange;
    private JRadioButton radioUseLast;
    private JRadioButton radioSameAsDocument;
    private JRadioButton radioSetNew;
    private final JTextField inputPictureFolder = new JTextField();
    private final JPanel btnPanel = new JPanel();
    private JButton btnCancel;
    private JButton btnSave;
    private final JCheckBox checkSave = Swinger.getRiderCheckBox("savesettings.pictures");
    private static final int RESULT_SAVE = 0;
    private static final int RESULT_CANCEL = 1;
    private int result = 0;
    private TITextFileInfo fileInfo;
    private Frame frame;
    private static final String DEFAULT_FOLDER_NAME = "main";

    public SaveSettingsDialog(Frame frame, TITextFileInfo tITextFileInfo) {
        super(frame, true);
        this.frame = frame;
        try {
            this.init();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
        this.initDialogContents(tITextFileInfo);
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setTitle(AppPrefs.getLabel("savesettings.title"));
        this.setVisible(true);
    }

    private void initDialogContents(TITextFileInfo tITextFileInfo) {
        Utils.addKeyActions(this.inputFolder);
        Utils.addKeyActions(this.inputVariable);
        Utils.addKeyActions(this.inputComment);
        Utils.addKeyActions(this.inputPictureFolder);
        if (tITextFileInfo.getFolderName().equals("")) {
            this.inputFolder.setText(DEFAULT_FOLDER_NAME);
            this.inputComment.setText("created by (c)WordRider 0.55");
        } else {
            this.inputFolder.setText(tITextFileInfo.getFolderName());
            this.inputComment.setText(tITextFileInfo.getComment());
        }
        this.inputVariable.setText(tITextFileInfo.getVarName());
        this.inputPictureFolder.setText(tITextFileInfo.getPictureFolder());
        switch (tITextFileInfo.getPictureProcessingType()) {
            case 3: {
                this.checkSave.setSelected(false);
                break;
            }
            case 4: {
                this.radioSameAsDocument.setSelected(true);
                break;
            }
            case 0: {
                this.radioDontChange.setSelected(true);
                break;
            }
            case 1: {
                this.radioUseLast.setSelected(true);
                break;
            }
            case 2: {
                this.radioSetNew.setSelected(true);
            }
        }
        this.checkSave.setSelected(tITextFileInfo.getPictureProcessingType() != 3);
        this.checkSave_actionPerformed();
        this.inputPictureFolder.setEnabled(this.radioSetNew.isSelected());
        Swinger.inputFocus(this.inputFolder);
    }

    public TITextFileInfo getResult() {
        if (this.result == 1) {
            return null;
        }
        return this.fileInfo;
    }

    void btnCancel_actionPerformed() {
        this.dispose();
    }

    private boolean checkNameValidity(JTextField jTextField, boolean bl, int n) {
        boolean bl2 = true;
        String string = jTextField.getText();
        if (string == null || string.equals("") && !jTextField.equals(this.inputComment)) {
            Swinger.showErrorDialog(this.frame, AppPrefs.getLabel("savesettings.mustbeset"));
            bl2 = false;
        } else if (bl && Character.isDigit(string.charAt(0))) {
            Swinger.showErrorDialog(this.frame, AppPrefs.getLabel("savesettings.startsdigit"));
            bl2 = false;
        } else if (string.length() > n) {
            Swinger.showErrorDialog(this.frame, AppPrefs.getLabel("savesettings.toolong", String.valueOf(n)));
            bl2 = false;
        }
        if (!bl2) {
            Swinger.inputFocus(jTextField);
        }
        return bl2;
    }

    void btnSave_actionPerformed() {
        int n;
        if (!(this.checkNameValidity(this.inputFolder, true, 8) && this.checkNameValidity(this.inputVariable, true, 8) && this.checkNameValidity(this.inputComment, false, 40))) {
            return;
        }
        this.fileInfo = new TITextFileInfo();
        this.fileInfo.setComment(this.inputComment.getText());
        this.fileInfo.setFolderName(this.inputFolder.getText());
        this.fileInfo.setVarName(this.inputVariable.getText());
        if (!this.checkSave.isSelected()) {
            n = 3;
        } else {
            AbstractButton abstractButton = this.buttonGroup.getSelected();
            if (abstractButton.equals(this.radioDontChange)) {
                n = 0;
            } else if (abstractButton.equals(this.radioUseLast)) {
                n = 1;
            } else if (abstractButton.equals(this.radioSameAsDocument)) {
                n = 4;
            } else if (abstractButton.equals(this.radioSetNew)) {
                if (!this.checkNameValidity(this.inputPictureFolder, true, 8)) {
                    return;
                }
                n = 1;
                this.fileInfo.setPictureFolder(this.inputPictureFolder.getText());
            } else {
                n = 0;
            }
        }
        this.fileInfo.setPictureProcessingType(n);
        this.dispose();
    }

    void checkSave_actionPerformed() {
        boolean bl = this.checkSave.isSelected();
        this.radioDontChange.setEnabled(bl);
        this.radioSetNew.setEnabled(bl);
        this.radioUseLast.setEnabled(bl);
        this.radioSameAsDocument.setEnabled(bl);
    }

    private void init() throws Exception {
        this.inputFolder.setDocument(new LimitedPlainDocument(8, false));
        this.inputVariable.setDocument(new LimitedPlainDocument(8, false));
        this.inputComment.setDocument(new LimitedPlainDocument(40, true));
        this.inputPictureFolder.setDocument(new LimitedPlainDocument(8, false));
        Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
        this.inputFolder.addFocusListener(selectAllOnFocusListener);
        this.inputVariable.addFocusListener(selectAllOnFocusListener);
        this.inputComment.addFocusListener(selectAllOnFocusListener);
        this.inputPictureFolder.addFocusListener(selectAllOnFocusListener);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(AppPrefs.getLabel("savesettings.input.folder"));
        jLabel.setDisplayedMnemonic(AppPrefs.getMnemonic("savesettings.input.folder"));
        jLabel.setLabelFor(this.inputFolder);
        JLabel jLabel2 = new JLabel(AppPrefs.getLabel("savesettings.input.variable"));
        jLabel2.setDisplayedMnemonic(AppPrefs.getMnemonic("savesettings.input.variable"));
        jLabel2.setLabelFor(this.inputVariable);
        JLabel jLabel3 = new JLabel(AppPrefs.getLabel("savesettings.input.comment"));
        jLabel3.setDisplayedMnemonic(AppPrefs.getMnemonic("savesettings.input.comment"));
        jLabel3.setLabelFor(this.inputComment);
        this.picturePanel.setEnabled(true);
        this.picturePanel.setBorder(new TitledBorder(BorderFactory.createLineBorder(Color.gray, 1), AppPrefs.getLabel("savesettings.pictures.folder")));
        this.picturePanel.setLayout(new GridBagLayout());
        this.radioDontChange = Swinger.getRiderRadio("savesettings.pictures.samesource");
        this.radioSameAsDocument = Swinger.getRiderRadio("savesettings.pictures.samefolder");
        this.radioUseLast = Swinger.getRiderRadio("savesettings.pictures.lastfolder");
        this.radioSetNew = Swinger.getRiderRadio("savesettings.pictures.newfolder");
        this.radioSameAsDocument.addActionListener(new RadiosAdapter());
        this.radioDontChange.addActionListener(new RadiosAdapter());
        this.radioUseLast.addActionListener(new RadiosAdapter());
        this.radioSetNew.addActionListener(new RadiosAdapter());
        this.btnPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(90, 25);
        this.btnCancel = Swinger.getRiderButton("savesettings.cancelBtn");
        this.btnCancel.setMinimumSize(dimension);
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
        this.btnSave = Swinger.getRiderButton("savesettings.saveBtn");
        this.btnSave.setMinimumSize(dimension);
        this.btnSave.setPreferredSize(dimension);
        this.btnSave.setMaximumSize(dimension);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnSave.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        this.checkSave.addActionListener(new CheckSaveAdapter());
        container.add((Component)jLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(3, 4, 4, 0), 0, 0));
        container.add((Component)jLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 4, 0), 0, 0));
        container.add((Component)this.inputFolder, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(4, 4, 4, 4), 20, 0));
        container.add((Component)this.inputVariable, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(4, 4, 4, 4), 80, 0));
        container.add((Component)this.inputComment, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 4, 4, 4), 0, 0));
        container.add((Component)jLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 3, new Insets(4, 4, 4, 0), 13, 0));
        this.picturePanel.add((Component)this.radioDontChange, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
        this.picturePanel.add((Component)this.radioUseLast, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 2, 2), 0, 0));
        this.picturePanel.add((Component)this.radioSetNew, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
        this.picturePanel.add((Component)this.radioSameAsDocument, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, 0), 0, 0));
        this.picturePanel.add((Component)this.inputPictureFolder, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 3, new Insets(0, -60, 4, 5), 114, 0));
        container.add((Component)this.btnPanel, new GridBagConstraints(0, 4, 4, 1, 1.0, 1.0, 17, 3, new Insets(0, 0, 0, 0), 28, 0));
        container.add((Component)this.checkSave, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 3, new Insets(0, 4, 0, -20), 5, 0));
        this.buttonGroup.add(this.radioDontChange);
        this.buttonGroup.add(this.radioUseLast);
        this.buttonGroup.add(this.radioSameAsDocument);
        this.buttonGroup.add(this.radioSetNew);
        this.btnPanel.add((Component)this.btnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 11, 4, 7), 0, 0));
        this.btnPanel.add((Component)this.btnSave, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 133, 4, 5), 0, 0));
        container.add((Component)this.picturePanel, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 13, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.setSize(350, 195);
        this.pack();
    }

    private class RadiosAdapter
    implements ActionListener {
        private RadiosAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = actionEvent.getSource().equals(SaveSettingsDialog.this.radioSetNew);
            SaveSettingsDialog.this.inputPictureFolder.setEnabled(bl);
            if (bl) {
                Swinger.inputFocus(SaveSettingsDialog.this.inputPictureFolder);
            }
        }
    }

    private class CheckSaveAdapter
    implements ActionListener {
        private CheckSaveAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveSettingsDialog.this.checkSave_actionPerformed();
        }
    }

    private class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(SaveSettingsDialog.this.btnSave)) {
                SaveSettingsDialog.this.btnSave_actionPerformed();
            } else {
                SaveSettingsDialog.this.btnCancel_actionPerformed();
            }
        }
    }

    private static class LimitedPlainDocument
    extends PlainDocument {
        private int maxLen = -1;
        private boolean canStartWithDigit;

        private boolean isAcceptable(char[] cArray) {
            int n = cArray.length;
            for (int i = 0; i < n; ++i) {
                if (Character.isLetter(cArray[i]) || Character.isDigit(cArray[i])) continue;
                return false;
            }
            return true;
        }

        public LimitedPlainDocument(int n, boolean bl) {
            this.maxLen = n;
            this.canStartWithDigit = bl;
        }

        public final void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null && (this.maxLen > 0 && this.getLength() + string.length() > this.maxLen || !this.canStartWithDigit && this.getLength() == 0 && string.length() > 0 && Character.isDigit(string.charAt(0)) || !this.isAcceptable(string.toCharArray()))) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

