/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.plugintools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.PluginTool;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class BreakpointList
extends PluginTool
implements CaretListener,
PropertyChangeListener,
DocumentListener,
ListSelectionListener {
    private static JTextComponent editor;
    private final JList list = new JList();
    private ListViewModel listModel;

    public BreakpointList() {
        try {
            this.list.addKeyListener(new UnsetBreakpointListener());
            this.list.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2 && BreakpointList.this.list.getSelectedIndex() != -1) {
                        BreakpointList.getEditor().requestFocus();
                        mouseEvent.consume();
                    }
                }
            });
            this.list.setFont(RiderStyles.getAreaFont());
            this.list.addListSelectionListener(this);
            this.list.setCellRenderer(new MyCellRenderer());
            this.setLayout(new BorderLayout());
            this.list.setBorder(new EmptyBorder(2, 2, 2, 4));
            this.add((Component)new JScrollPane(this.list), "Center");
            this.setPreferredSize(new Dimension(250, 300));
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public final String getName() {
        return AppPrefs.getLabel("breakpoints.title");
    }

    public String getTabName() {
        return this.getName();
    }

    public final Icon getIcon() {
        return Swinger.getIcon("view_bookm.gif");
    }

    public final String getTip() {
        return AppPrefs.getLabel("breakpoints.tooltip");
    }

    public void activate() {
        this.setFileInstance(MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().getActiveFileInstance());
        Utils.log(0, "BreakpointList activated");
    }

    public void deactivate() {
        this.setFileInstance(null);
        Utils.log(0, "BreakpointList deactivated");
    }

    public void setFileInstance(IFileInstance iFileInstance) {
        if (iFileInstance != null) {
            this.setEditor(iFileInstance.getTextComponent());
        } else {
            this.setEditor(null);
        }
        this.setEnabled(editor != null);
    }

    private final void setEditor(JTextComponent jTextComponent) {
        if (editor == jTextComponent) {
            return;
        }
        if (editor != null) {
            editor.getDocument().removeDocumentListener(this);
            editor.removePropertyChangeListener(this);
            editor.removeCaretListener(this);
        }
        editor = jTextComponent;
        if (jTextComponent == null) {
            this.listModel = null;
            this.list.setModel(new DefaultListModel());
        } else {
            Document document = jTextComponent.getDocument();
            document.addDocumentListener(this);
            jTextComponent.addPropertyChangeListener(this);
            jTextComponent.addCaretListener(this);
            this.listModel = new ListViewModel(document);
            this.list.setModel(this.listModel);
        }
    }

    private static JTextComponent getEditor() {
        return editor;
    }

    public final void caretUpdate(CaretEvent caretEvent) {
        if (!this.list.hasFocus()) {
            Element element = editor.getDocument().getDefaultRootElement();
            if (this.listModel.contains(element = element.getElement(element.getElementIndex(caretEvent.getDot())))) {
                this.list.setSelectedValue(element, true);
            }
        }
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource().equals(BreakpointList.getEditor()) && propertyChangeEvent.getPropertyName().equals("document")) {
            ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this);
            Document document = (Document)propertyChangeEvent.getNewValue();
            document.addDocumentListener(this);
            this.listModel = new ListViewModel(document);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    BreakpointList.this.list.setModel(BreakpointList.this.listModel);
                }
            });
        }
    }

    public final void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (this.list.hasFocus() && this.list.getSelectedIndex() >= 0) {
            Rectangle rectangle;
            Element element = (Element)this.list.getSelectedValue();
            try {
                rectangle = editor.modelToView(element.getStartOffset());
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
                return;
            }
            if (rectangle == null) {
                return;
            }
            rectangle.y += -10;
            rectangle.height = BreakpointList.editor.getVisibleRect().height;
            editor.setSelectionStart(element.getStartOffset());
            editor.setSelectionEnd(element.getStartOffset());
            editor.scrollRectToVisible(rectangle);
        }
    }

    public final void changedUpdate(DocumentEvent documentEvent) {
        this.updateList(documentEvent);
    }

    public final void insertUpdate(final DocumentEvent documentEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BreakpointList.this.updateList(documentEvent);
            }
        });
    }

    public final void removeUpdate(DocumentEvent documentEvent) {
        this.updateList(documentEvent);
    }

    private void updateList(DocumentEvent documentEvent) {
        this.updateList(documentEvent, BreakpointList.getEditor().getDocument().getDefaultRootElement());
    }

    private void updateList(DocumentEvent documentEvent, Element element) {
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        if (elementChange != null) {
            int n;
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            if (elementArray != null && elementArray.length > 0) {
                for (n = 0; n < elementArray.length; ++n) {
                    this.listModel.removeElement(elementArray[n]);
                }
            }
            if (elementArray2 != null && elementArray2.length > 0) {
                for (n = 0; n < elementArray2.length; ++n) {
                    this.listModel.addIfCan(elementArray2[n]);
                }
            }
        }
        this.listModel.checkValue(element.getElement(element.getElementIndex(documentEvent.getOffset())));
        Utils.logDebug("counter");
        this.listModel.updateData();
    }

    public boolean closeSoft() {
        return false;
    }

    public void closeHard() {
    }

    private static final class ListViewModel
    extends AbstractListModel {
        private final Vector delegate = new Vector();
        private final Map stringsMap = new Hashtable();
        private Document document;
        boolean wasChanged = false;

        public ListViewModel(Document document) {
            this.document = document;
            Element element = document.getDefaultRootElement();
            int n = element.getElementCount();
            for (int i = 0; i < n; ++i) {
                Element element2 = element.getElement(i);
                if (!RiderStyles.isBookmark(element2)) continue;
                this.delegate.addElement(element2);
                this.stringsMap.put(element2, this.convertValueToText(element2));
            }
            if (this.delegate.size() > 0) {
                this.fireContentsChanged(this, 0, this.delegate.size());
            }
        }

        public final void addIfCan(Element element) {
            if (RiderStyles.isBookmark(element)) {
                this.wasChanged = true;
                this.delegate.addElement(element);
                this.stringsMap.put(element, this.convertValueToText(element));
            }
        }

        public final int getSize() {
            return this.delegate.size();
        }

        public final Object getElementAt(int n) {
            return n < this.delegate.size() ? this.delegate.elementAt(n) : null;
        }

        public final void updateData() {
            if (this.wasChanged && this.delegate.size() > 0) {
                TreeSet treeSet = new TreeSet(new MyComparator());
                treeSet.addAll(this.delegate);
                this.delegate.removeAllElements();
                this.delegate.addAll(treeSet);
                this.wasChanged = false;
                this.fireContentsChanged(this, 0, this.delegate.size());
            }
        }

        public final void checkValue(Element element) {
            boolean bl = RiderStyles.isBookmark(element);
            if (this.contains(element)) {
                if (!bl) {
                    this.removeElement(element);
                } else {
                    int n = this.delegate.indexOf(element);
                    SwingUtilities.invokeLater(new Runnable(this, element, n){
                        private final /* synthetic */ Element val$element;
                        private final /* synthetic */ int val$index;
                        private final /* synthetic */ ListViewModel this$0;
                        {
                            this.this$0 = listViewModel;
                            this.val$element = element;
                            this.val$index = n;
                        }

                        public void run() {
                            Object object = ListViewModel.access$800(this.this$0, this.val$element);
                            if (!object.equals(ListViewModel.access$700(this.this$0).get(this.val$element))) {
                                ListViewModel.access$700(this.this$0).put(this.val$element, object);
                                ListViewModel.access$900(this.this$0, this, this.val$index, this.val$index);
                            }
                        }
                    });
                }
            } else if (bl) {
                this.delegate.addElement(element);
                this.stringsMap.put(element, this.convertValueToText(element));
                this.wasChanged = true;
            }
        }

        public final boolean contains(Object object) {
            return this.delegate.contains(object);
        }

        public final void removeElement(Object object) {
            int n = this.delegate.indexOf(object);
            this.delegate.removeElement(object);
            this.stringsMap.remove(object);
            this.wasChanged = true;
            if (n >= 0) {
                this.fireContentsChanged(this, n, n);
            }
        }

        private Object convertValueToText(Element element) {
            int n = element.getStartOffset();
            try {
                int n2 = Utilities.getRowEnd(BreakpointList.getEditor(), n);
                String string = this.document.getText(n, n2 != -1 ? n2 - n + 1 : element.getEndOffset() - n);
                return string == null || string.equals("\n") ? "-" : string;
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
                return "";
            }
        }

        public Object getStringValue(Object object) {
            return this.stringsMap.get(object);
        }

        static /* synthetic */ Map access$700(ListViewModel listViewModel) {
            return listViewModel.stringsMap;
        }

        static /* synthetic */ Object access$800(ListViewModel listViewModel, Element element) {
            return listViewModel.convertValueToText(element);
        }

        static /* synthetic */ void access$900(ListViewModel listViewModel, Object object, int n, int n2) {
            listViewModel.fireContentsChanged(object, n, n2);
        }

        private final class MyComparator
        implements Comparator {
            private MyComparator() {
            }

            public final int compare(Object object, Object object2) {
                return ((Element)object).getStartOffset() - ((Element)object2).getStartOffset();
            }
        }
    }

    private final class MyCellRenderer
    extends DefaultListCellRenderer {
        private MyCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, BreakpointList.this.listModel.getStringValue(object), n, bl, bl2);
        }

        public final Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension.width += 5;
            }
            return dimension;
        }
    }

    private final class UnsetBreakpointListener
    extends KeyAdapter {
        private UnsetBreakpointListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 127) {
                Object[] objectArray = BreakpointList.this.list.getSelectedValues();
                int n = objectArray.length;
                RiderDocument riderDocument = (RiderDocument)BreakpointList.getEditor().getDocument();
                for (int i = 0; i < n; ++i) {
                    riderDocument.toggleBookmark((Element)objectArray[i]);
                }
                keyEvent.consume();
                return;
            }
            if (keyEvent.getKeyCode() == 10) {
                BreakpointList.getEditor().requestFocus();
                keyEvent.consume();
                return;
            }
        }
    }
}

