/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.ti89;

import java.io.DataInputStream;
import java.io.IOException;
import net.wordrider.ti89.TIFileReader;
import net.wordrider.ti89.TITextFileInfo;

public final class TITextFileReader
extends TIFileReader {
    private static final String[] supportedFormats = new String[]{"**TI92P*", "**TI89**"};
    private String content = null;

    public TITextFileReader() {
        this.fileInfo = new TITextFileInfo();
    }

    public final TITextFileInfo getTextFileInfo() {
        return (TITextFileInfo)this.fileInfo;
    }

    protected final void readContent(DataInputStream dataInputStream) throws IOException {
        int n;
        dataInputStream.skipBytes(4);
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = dataInputStream.readUnsignedByte()) != 0 && n != -1) {
            stringBuffer.append((char)n);
        }
        if (n == 0 || n == -1) {
            dataInputStream.skipBytes(1);
        }
        this.content = stringBuffer.toString();
    }

    protected final boolean isSupportedHeader(String string) {
        int n = supportedFormats.length;
        for (int i = 0; i < n; ++i) {
            if (!supportedFormats[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public final String getContent() {
        return this.content;
    }

    public final int getDataType() {
        return DATA_TYPES[0];
    }

    protected final String getFileHeaderType() {
        return supportedFormats[0];
    }

    protected final char getCheckSum() {
        if (this.content == null) {
            return '\u0000';
        }
        int n = this.content.length();
        int n2 = this.content.length() + 4;
        char[] cArray = this.content.toCharArray();
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 = (char)(n3 + cArray[i]);
        }
        return (char)(n3 + 224 + 1 + ((n2 & 0xFF) + (n2 >> 8 & 0xFF)));
    }
}

