/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.utilities;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URLClassLoader;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import net.wordrider.core.AppPrefs;
import net.wordrider.utilities.Utils;

public final class Swinger {
    public static final int RESULT_CANCEL = 2;
    public static final int RESULT_NO = 1;
    public static final int RESULT_YES = 0;
    private static final String MESSAGE_ERROR_TITLE_CODE = "message.error.title";
    private static final String MESSAGE_CONFIRM_TITLE_CODE = "message.confirm.title";
    private static final String MESSAGE_INFORMATION_TITLE_CODE = "message.information.title";
    private static final String MESSAGE_BTN_YES_CODE = "message.button.yes";
    private static final String MESSAGE_BTN_NO_CODE = "message.button.no";
    private static final String MESSAGE_BTN_CANCEL_CODE = "message.button.cancel";
    private static final double FACTOR = 0.92;
    public static boolean ANTIALIASING = AppPrefs.getProperty("net.wordrider.area.antialiasing", false);

    public static final JRadioButton getRiderRadio(String string) {
        JRadioButton jRadioButton = new JRadioButton(AppPrefs.getLabel(string));
        return jRadioButton;
    }

    public static final JCheckBox getRiderCheckBox(String string) {
        JCheckBox jCheckBox = new JCheckBox(AppPrefs.getLabel(string));
        jCheckBox.setMnemonic(AppPrefs.getMnemonic(string));
        return jCheckBox;
    }

    public static final JButton getRiderButton(String string) {
        JButton jButton = new JButton(AppPrefs.getLabel(string));
        jButton.setMnemonic(AppPrefs.getMnemonic(string));
        return jButton;
    }

    public static final ImageIcon getIcon(String string) {
        if (string == null) {
            return null;
        }
        try {
            return new ImageIcon(ImageIO.read(((URLClassLoader)Swinger.class.getClassLoader()).findResource("resources/images/" + string)));
        }
        catch (Exception exception) {
            Utils.log(3, "Cannot load image " + string + "\nReason:" + exception.getMessage());
            return null;
        }
    }

    public static final void centerDialog(Frame frame, Component component) {
        Dimension dimension = component.getPreferredSize();
        Dimension dimension2 = frame.getSize();
        Point point = frame.getLocation();
        component.setLocation((dimension2.width - dimension.width) / 2 + point.x, (dimension2.height - dimension.height) / 2 + point.y);
    }

    public static final void inputFocus(final JTextComponent jTextComponent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jTextComponent.requestFocus();
            }
        });
    }

    public static final void showErrorDialog(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, AppPrefs.getLabel(MESSAGE_ERROR_TITLE_CODE), 0);
    }

    public static final void showInformationDialog(Frame frame, String string) {
        JOptionPane.showMessageDialog(frame, string, AppPrefs.getLabel(MESSAGE_INFORMATION_TITLE_CODE), 1);
    }

    public static final int getChoice(Frame frame, String string) {
        return JOptionPane.showOptionDialog(frame, string, AppPrefs.getLabel(MESSAGE_CONFIRM_TITLE_CODE), 1, 3, null, new String[]{AppPrefs.getLabel(MESSAGE_BTN_YES_CODE), AppPrefs.getLabel(MESSAGE_BTN_NO_CODE)}, null);
    }

    public static int getChoiceCancel(Frame frame, String string) {
        return JOptionPane.showOptionDialog(frame, string, AppPrefs.getLabel(MESSAGE_CONFIRM_TITLE_CODE), 1, 3, null, new String[]{AppPrefs.getLabel(MESSAGE_BTN_YES_CODE), AppPrefs.getLabel(MESSAGE_BTN_NO_CODE), AppPrefs.getLabel(MESSAGE_BTN_CANCEL_CODE)}, null);
    }

    public static Color brighter(Color color) {
        Color color2;
        if (color == null) {
            return new JPanel().getBackground();
        }
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        int n4 = 12;
        if (n == 0 && n2 == 0 && n3 == 0) {
            return new Color(n4, n4, n4);
        }
        if (n > 0 && n < n4) {
            n = n4;
        }
        if (n2 > 0 && n2 < n4) {
            n2 = n4;
        }
        if (n3 > 0 && n3 < n4) {
            n3 = n4;
        }
        return (color2 = new Color(Math.min((int)((double)n / 0.92), 255), Math.min((int)((double)n2 / 0.92), 255), Math.min((int)((double)n3 / 0.92), 255))).equals(Color.WHITE) ? new JPanel().getBackground() : color2;
    }

    public static final class SelectAllOnFocusListener
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                Component component = focusEvent.getComponent();
                ((JTextComponent)component).selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }
}

