/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.UndoAction;

final class AreaUndoManager
extends UndoManager
implements PropertyChangeListener {
    private final RiderArea editor;
    private CompoundEdit compoundEdit;
    private int lastOffset;
    private boolean multipleUndo = false;
    private boolean multipleUndoFirstTime = false;

    public AreaUndoManager(RiderArea riderArea) {
        this.editor = riderArea;
        riderArea.getDocument().addUndoableEditListener(this);
        riderArea.addPropertyChangeListener("document", this);
        riderArea.addPropertyChangeListener("undoredo", this);
    }

    public final boolean addEdit(UndoableEdit undoableEdit) {
        boolean bl = super.addEdit(undoableEdit);
        UndoAction.getInstance().updateUndoState(this.editor);
        this.editor.setModified(this.canUndoOrRedo());
        RedoAction.getInstance().updateRedoState(this.editor);
        return bl;
    }

    public final void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (this.multipleUndoFirstTime) {
            if (this.compoundEdit != null) {
                this.compoundEdit.end();
            }
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            this.multipleUndoFirstTime = false;
            return;
        }
        if (this.compoundEdit == null) {
            this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
            return;
        }
        int n = this.editor.getCaretPosition() - this.lastOffset;
        if (Math.abs(n) == 1 || this.multipleUndo) {
            this.compoundEdit.addEdit(undoableEditEvent.getEdit());
            this.editor.setModified(this.canUndoOrRedo());
            this.lastOffset += n;
            return;
        }
        this.compoundEdit.end();
        this.compoundEdit = this.startCompoundEdit(undoableEditEvent.getEdit());
    }

    private final CompoundEdit startCompoundEdit(UndoableEdit undoableEdit) {
        this.lastOffset = this.editor.getCaretPosition();
        this.compoundEdit = new MyCompoundEdit(this.lastOffset);
        this.compoundEdit.addEdit(undoableEdit);
        this.addEdit(this.compoundEdit);
        return this.compoundEdit;
    }

    public synchronized void discardAllEdits() {
        super.discardAllEdits();
        UndoAction.getInstance().updateUndoState(this.editor);
        RedoAction.getInstance().updateRedoState(this.editor);
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.getEditor()) {
            if (propertyChangeEvent.getPropertyName().equals("document")) {
                ((Document)propertyChangeEvent.getOldValue()).removeUndoableEditListener(this);
                Document document = (Document)propertyChangeEvent.getNewValue();
                document.addUndoableEditListener(this);
            } else if (propertyChangeEvent.getPropertyName().equals("undoredo")) {
                this.multipleUndo = this.multipleUndoFirstTime = ((Boolean)propertyChangeEvent.getNewValue()).booleanValue();
            }
        }
    }

    private final JTextComponent getEditor() {
        return this.editor;
    }

    private final class MyCompoundEdit
    extends CompoundEdit {
        private int caretPosition;

        public MyCompoundEdit(int n) {
            this.caretPosition = n;
        }

        public final boolean isInProgress() {
            return false;
        }

        public final void undo() throws CannotUndoException {
            if (AreaUndoManager.this.compoundEdit != null) {
                AreaUndoManager.this.compoundEdit.end();
            }
            super.undo();
            this.updateEditor();
            AreaUndoManager.this.compoundEdit = null;
        }

        private void updateEditor() {
            if (this.caretPosition < AreaUndoManager.this.editor.getText().length()) {
                AreaUndoManager.this.editor.setCaretPosition(this.caretPosition);
            }
            AreaUndoManager.this.editor.validate();
            AreaUndoManager.this.editor.repaint();
        }

        public void redo() throws CannotRedoException {
            super.redo();
            this.updateEditor();
        }
    }
}

