/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Stroke;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import net.wordrider.area.SeparatorLine;
import net.wordrider.ti89.TIImageDecoder;
import net.wordrider.utilities.Utils;

public final class RiderStyles {
    public static final String TI89MAXLENGTHSTRING = "01234567890123456789012345";
    public static final String TI92MAXLENGTHSTRING = "012345678901234567890123456789012345";
    public static final Stroke DOTTED_STROKE = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{2.0f}, 0.0f);
    private static final Object STYLE_INVERTED = "INVERT";
    public static final Object STYLE_UNDERLINEDOTTED = "UNDERLINEDOTTED";
    private static final Object STYLE_BOOKMARK = "BOOKMARK";
    private static final Object STYLE_VECTOR = "VECTOR";
    private static final Object STYLE_MATH = "MATH";
    static final Object STYLE_WORDWRAP = "WORDWRAP";
    public static final String STYLE_ALIGMENT_LEFT = "aligmentLeft";
    public static final String STYLE_ALIGMENT_RIGHT = "aligmentRight";
    public static final String STYLE_ALIGMENT_CENTER = "aligmentCenter";
    public static final String STYLE_FONT_MINI = "miniSize";
    public static final String STYLE_FONT_NORMAL = "normalSize";
    public static final String STYLE_FONT_MAXI = "maxiSize";
    public static final String STYLE_MARGIN10 = "margin10";
    public static final String STYLE_MARGIN20 = "margin20";
    public static final String STYLE_MARGIN30 = "margin30";
    public static final int ALIGN_LEFT = 0;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 1;
    public static final int SIZE_MINI = 11;
    public static final int SIZE_NORMAL = 13;
    public static final int SIZE_MAXI = 16;
    public static final int MARGIN_0 = 0;
    public static final int MARGIN_10 = 10;
    public static final int MARGIN_20 = 20;
    public static final int MARGIN_30 = 30;
    public static final int SINGLE_LINE = 0;
    public static final int DOUBLE_LINE = 1;
    public static final String FONT_NAME = "Ti-92p.ttf";
    public static final String FONT_FAMILY = "Ti92Pluspc";
    private static final Font font = RiderStyles.readDefaultFont();
    private static final Font maxiFont = font.deriveFont(1, 15.0f);
    public static Style normalStyle;
    public static Style miniStyle;
    public static Style maxiStyle;
    private static Style superscriptStyle;
    public static Style margin10Style;
    public static Style margin20Style;
    public static Style margin30Style;
    public static Style aligmentLeftStyle;
    public static Style aligmentRightStyle;
    public static Style aligmentCenteredStyle;
    public static Style underlineStyle;
    private static Style strikethroughStyle;
    public static Style underlineDottedStyle;
    private static Style basicStyle;
    public static Style invertStyle;
    public static Style mathStyle;
    private static Style vectorStyle;
    private static Style wordwrapStyle;
    public static SimpleAttributeSet bookmarkStyle;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static Font readDefaultFont() {
        Font font;
        block16: {
            InputStream inputStream;
            block15: {
                font = new Font(FONT_FAMILY, 0, 13);
                if (font.getFamily().equalsIgnoreCase(FONT_FAMILY)) {
                    return font;
                }
                inputStream = null;
                inputStream = RiderStyles.class.getClassLoader().getResourceAsStream("resources/fonts/Ti-92p.ttf");
                if (inputStream == null) break block15;
                font = Font.createFont(0, inputStream).deriveFont(0, 13.0f);
            }
            Object var4_2 = null;
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                break block16;
            }
            catch (IOException iOException) {
                Utils.processException(iOException);
            }
            break block16;
            {
                catch (FontFormatException fontFormatException) {
                    Utils.processException(fontFormatException);
                    Object var4_3 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException) {
                        Utils.processException(iOException);
                    }
                    break block16;
                }
                catch (IOException iOException) {
                    Utils.processException(iOException);
                    Object var4_4 = null;
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        break block16;
                    }
                    catch (IOException iOException2) {
                        Utils.processException(iOException2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Utils.processException(iOException);
                }
                throw throwable;
            }
        }
        return font;
    }

    public static final boolean isCorrectFont() {
        return font.getFamily().equalsIgnoreCase(FONT_FAMILY);
    }

    public static final void createDefaultStyles(StyleContext styleContext) {
        Style style = styleContext.getStyle("default");
        StyleConstants.setFontFamily(style, font.getFamily());
        StyleConstants.setFontSize(style, 13);
        StyleConstants.setForeground(style, RiderStyles.getAreaFontForeground());
        StyleConstants.setBackground(style, RiderStyles.getAreaFontBackground());
        basicStyle = styleContext.addStyle("basic", null);
        StyleConstants.setFontFamily(basicStyle, font.getFamily());
        StyleConstants.setForeground(basicStyle, RiderStyles.getAreaFontForeground());
        StyleConstants.setBackground(basicStyle, RiderStyles.getAreaFontBackground());
        normalStyle = styleContext.addStyle(STYLE_FONT_NORMAL, basicStyle);
        StyleConstants.setFontSize(normalStyle, 13);
        StyleConstants.setBold(normalStyle, false);
        miniStyle = styleContext.addStyle(STYLE_FONT_MINI, basicStyle);
        StyleConstants.setFontSize(miniStyle, 11);
        StyleConstants.setBold(miniStyle, false);
        maxiStyle = styleContext.addStyle(STYLE_FONT_MAXI, basicStyle);
        StyleConstants.setFontSize(maxiStyle, 16);
        StyleConstants.setBold(maxiStyle, true);
        StyleConstants.setSuperscript(maxiStyle, false);
        superscriptStyle = styleContext.addStyle("superscript", miniStyle);
        StyleConstants.setSuperscript(superscriptStyle, true);
        aligmentLeftStyle = styleContext.addStyle(STYLE_ALIGMENT_LEFT, basicStyle);
        StyleConstants.setLeftIndent(aligmentLeftStyle, 0.0f);
        StyleConstants.setAlignment(aligmentLeftStyle, 0);
        aligmentRightStyle = styleContext.addStyle(STYLE_ALIGMENT_RIGHT, aligmentLeftStyle);
        StyleConstants.setAlignment(aligmentRightStyle, 2);
        StyleConstants.setLeftIndent(aligmentRightStyle, 0.0f);
        aligmentCenteredStyle = styleContext.addStyle(STYLE_ALIGMENT_CENTER, aligmentLeftStyle);
        StyleConstants.setAlignment(aligmentCenteredStyle, 1);
        StyleConstants.setLeftIndent(aligmentCenteredStyle, 0.0f);
        margin10Style = styleContext.addStyle(STYLE_MARGIN10, aligmentLeftStyle);
        StyleConstants.setLeftIndent(margin10Style, 10.0f);
        StyleConstants.setAlignment(margin10Style, 0);
        margin20Style = styleContext.addStyle(STYLE_MARGIN20, aligmentLeftStyle);
        StyleConstants.setLeftIndent(margin20Style, 20.0f);
        StyleConstants.setAlignment(margin20Style, 0);
        margin30Style = styleContext.addStyle(STYLE_MARGIN30, aligmentLeftStyle);
        StyleConstants.setLeftIndent(margin30Style, 30.0f);
        StyleConstants.setAlignment(margin30Style, 0);
        underlineStyle = styleContext.addStyle("underline", aligmentLeftStyle);
        StyleConstants.setUnderline(underlineStyle, true);
        strikethroughStyle = styleContext.addStyle("strikethrough", basicStyle);
        StyleConstants.setStrikeThrough(strikethroughStyle, true);
        underlineDottedStyle = styleContext.addStyle("underlineDotted", basicStyle);
        StyleConstants.setUnderline(underlineDottedStyle, false);
        RiderStyles.setProperty(underlineDottedStyle, STYLE_UNDERLINEDOTTED);
        invertStyle = styleContext.addStyle("invert", basicStyle);
        StyleConstants.setBackground(invertStyle, RiderStyles.getAreaFontForeground());
        StyleConstants.setForeground(invertStyle, RiderStyles.getAreaFontBackground());
        RiderStyles.setProperty(invertStyle, STYLE_INVERTED);
        mathStyle = styleContext.addStyle("math", normalStyle);
        RiderStyles.setProperty(mathStyle, STYLE_MATH);
        mathStyle.addAttributes(aligmentLeftStyle);
        StyleConstants.setBackground(mathStyle, RiderStyles.getAreaFontBackground());
        vectorStyle = styleContext.addStyle("vector", basicStyle);
        RiderStyles.setProperty(vectorStyle, STYLE_VECTOR);
        wordwrapStyle = styleContext.addStyle("wordwrap", wordwrapStyle);
        RiderStyles.setProperty(wordwrapStyle, STYLE_WORDWRAP);
        bookmarkStyle = new SimpleAttributeSet();
    }

    public static MutableAttributeSet setProperty(MutableAttributeSet mutableAttributeSet, Object object, boolean bl) {
        mutableAttributeSet.addAttribute(object, bl);
        return mutableAttributeSet;
    }

    private static void setProperty(MutableAttributeSet mutableAttributeSet, Object object) {
        mutableAttributeSet.addAttribute(object, true);
    }

    public static final boolean isReadonlySection(Element element) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            String string = element.getElement(i).getName();
            if (!string.equals("component") && !string.equals("icon")) continue;
            return true;
        }
        return false;
    }

    public static final Component isMoveableComponent(Element element) {
        int n = element.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            String string = element2.getName();
            if (!string.equals("component")) continue;
            return StyleConstants.getComponent(element2.getAttributes());
        }
        return null;
    }

    public static final boolean isUnderLine(AttributeSet attributeSet) {
        return StyleConstants.isUnderline(attributeSet);
    }

    public static final boolean isUnderLineDotted(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_UNDERLINEDOTTED);
        return object != null && (Boolean)object != false;
    }

    public static final boolean isExposant(AttributeSet attributeSet) {
        return StyleConstants.isSuperscript(attributeSet);
    }

    public static final boolean isInvert(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_INVERTED);
        return object != null && (Boolean)object != false;
    }

    public static final boolean isVector(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_VECTOR);
        return object != null && (Boolean)object != false;
    }

    public static final boolean isSize(AttributeSet attributeSet, int n) {
        return StyleConstants.getFontSize(attributeSet) == n;
    }

    public static final boolean isMath(Element element) {
        Object object = element.getAttributes().getAttribute(STYLE_MATH);
        return object != null && (Boolean)object != false;
    }

    public static final boolean isStrikeOut(AttributeSet attributeSet) {
        return StyleConstants.isStrikeThrough(attributeSet);
    }

    public static final boolean isAligment(AttributeSet attributeSet, int n) {
        return StyleConstants.getAlignment(attributeSet) == n;
    }

    public static final boolean isMargin(AttributeSet attributeSet, int n) {
        return (int)StyleConstants.getLeftIndent(attributeSet) == n;
    }

    public static final boolean isWordWrap(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(STYLE_WORDWRAP);
        return object != null && (Boolean)object != false;
    }

    public static final boolean isSupportedComponent(Element element) {
        if (element.getName().equals("component")) {
            return element.getAttributes().getAttribute(StyleConstants.ComponentAttribute) instanceof SeparatorLine;
        }
        return false;
    }

    public static final boolean isComponentLine(Element element, int n) {
        Object object;
        return element.getName().equals("component") && (object = element.getAttributes().getAttribute(StyleConstants.ComponentAttribute)) instanceof SeparatorLine && ((SeparatorLine)object).getLineType() == n;
    }

    public static final TIImageDecoder isSupportedImage(Element element) {
        ImageIcon imageIcon;
        ImageProducer imageProducer;
        if (element.getName().equals("icon") && (imageProducer = (imageIcon = (ImageIcon)element.getAttributes().getAttribute(StyleConstants.IconAttribute)).getImage().getSource()) instanceof TIImageDecoder) {
            return (TIImageDecoder)imageProducer;
        }
        return null;
    }

    public static final ImageIcon isImage(Element element) {
        ImageIcon imageIcon;
        ImageProducer imageProducer;
        if (element.getName().equals("icon") && (imageProducer = (imageIcon = (ImageIcon)element.getAttributes().getAttribute(StyleConstants.IconAttribute)).getImage().getSource()) instanceof TIImageDecoder) {
            return imageIcon;
        }
        return null;
    }

    public static final boolean isBookmark(Element element) {
        Object object = element.getAttributes().getAttribute(STYLE_BOOKMARK);
        return object != null && object.equals(element);
    }

    public static final int getAligment(AttributeSet attributeSet) {
        return StyleConstants.getAlignment(attributeSet);
    }

    public static final int getMargin(AttributeSet attributeSet) {
        return (int)StyleConstants.getLeftIndent(attributeSet);
    }

    public static final int getFontSize(AttributeSet attributeSet) {
        return StyleConstants.getFontSize(attributeSet);
    }

    public static final Font getAreaFont() {
        return font;
    }

    public static final Font getAreaBigFont() {
        return maxiFont;
    }

    private static Color getAreaFontForeground() {
        return Color.BLACK;
    }

    private static Color getAreaFontBackground() {
        return Color.WHITE;
    }

    public static final MutableAttributeSet updateVectorAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isVector(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_VECTOR, false) : vectorStyle;
    }

    public static final MutableAttributeSet updateUnderlineAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isUnderLine(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Underline, false) : underlineStyle;
    }

    public static final MutableAttributeSet flipUnderlineAttributes(MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = RiderStyles.isUnderLine(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Underline, false) : new SimpleAttributeSet(underlineStyle.copyAttributes());
        return RiderStyles.setProperty(mutableAttributeSet2, STYLE_UNDERLINEDOTTED, false);
    }

    public static final MutableAttributeSet flipUnderlineDottedAttributes(MutableAttributeSet mutableAttributeSet) {
        MutableAttributeSet mutableAttributeSet2 = RiderStyles.isUnderLineDotted(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_UNDERLINEDOTTED, false) : new SimpleAttributeSet(underlineDottedStyle.copyAttributes());
        StyleConstants.setUnderline(mutableAttributeSet2, false);
        return mutableAttributeSet2;
    }

    public static final MutableAttributeSet updateUnderlineDottedAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isUnderLineDotted(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_UNDERLINEDOTTED, false) : underlineDottedStyle;
    }

    public static final MutableAttributeSet updateWordWrapAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isWordWrap(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), STYLE_WORDWRAP, false) : wordwrapStyle;
    }

    public static final MutableAttributeSet updateInvertAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isInvert(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(basicStyle), STYLE_INVERTED, false) : invertStyle;
    }

    public static final MutableAttributeSet updateStrikedAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isStrikeOut(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.StrikeThrough, false) : strikethroughStyle;
    }

    public static final MutableAttributeSet updateExposantAttributes(MutableAttributeSet mutableAttributeSet) {
        return RiderStyles.isExposant(mutableAttributeSet) ? RiderStyles.setProperty(new SimpleAttributeSet(), StyleConstants.Superscript, false) : superscriptStyle;
    }

    public static final MutableAttributeSet updateBookmark(Element element) {
        bookmarkStyle.addAttribute(STYLE_BOOKMARK, element);
        return bookmarkStyle;
    }

    public static Color getMathStyleColor() {
        return Color.BLUE;
    }
}

