/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderArea;
import net.wordrider.area.RiderDocument;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.MainAppFrame;
import net.wordrider.dialogs.PictureDialog;
import net.wordrider.ti89.InvalidDataTypeException;
import net.wordrider.ti89.NotSupportedFileException;
import net.wordrider.ti89.TIImageDecoder;
import net.wordrider.utilities.Utils;

public final class InsertPictureAction
extends TextAreaAction {
    private static final InsertPictureAction instance = new InsertPictureAction();
    private static final String key = "lastPictureFolder";
    private static final String CODE = "InsertPictureAction";

    public static final InsertPictureAction getInstance() {
        return instance;
    }

    private InsertPictureAction() {
        super(CODE, KeyStroke.getKeyStroke(80, 2), "ins_pic_v2.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea != null) {
            MainAppFrame mainAppFrame;
            File file = new File(AppPrefs.getProperty(key, ""));
            PictureDialog pictureDialog = file.exists() ? new PictureDialog(file) : new PictureDialog();
            if (pictureDialog.showInsertDialog(mainAppFrame = MainApp.getInstance().getMainAppFrame()) != 0) {
                return;
            }
            File file2 = pictureDialog.getSelectedFile();
            if (file2 == null) {
                return;
            }
            AppPrefs.storeProperty(key, file2.getAbsolutePath());
            int n = riderArea.getCaretPosition();
            try {
                boolean bl;
                boolean bl2 = bl = Utilities.getRowStart(riderArea, n) == n;
                if (!bl) {
                    riderArea.getDocument().insertString(riderArea.getCaretPosition(), "\n", null);
                }
                TIImageDecoder tIImageDecoder = new TIImageDecoder();
                try {
                    if (!tIImageDecoder.openFromFile(file2)) {
                        JOptionPane.showMessageDialog(riderArea, "Image was loaded but the file might be corrupted (checksum mismatch)", "Warning", 2);
                    }
                }
                catch (InvalidDataTypeException invalidDataTypeException) {
                    Utils.log(2, invalidDataTypeException.getMessage());
                    JOptionPane.showMessageDialog(riderArea, invalidDataTypeException.getMessage(), "Error", 0);
                    return;
                }
                catch (NotSupportedFileException notSupportedFileException) {
                    Utils.log(2, notSupportedFileException.getMessage());
                    JOptionPane.showMessageDialog(riderArea, notSupportedFileException.getMessage(), "Error", 0);
                    return;
                }
                catch (IOException iOException) {
                    Utils.processException(iOException);
                    JOptionPane.showMessageDialog(riderArea, iOException.getMessage(), "Error", 0);
                    return;
                }
                RiderDocument riderDocument = riderArea.getDoc();
                riderDocument.removeBookmark(riderArea.getDoc().getParagraphElement(n));
                riderDocument.insertPicture(n, Toolkit.getDefaultToolkit().createImage(tIImageDecoder));
                riderDocument.insertString(n + 1, "\n", null);
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
            }
        }
    }
}

