/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.wordrider.area.RiderArea;
import net.wordrider.area.actions.RedoAction;
import net.wordrider.area.actions.TextAreaAction;
import net.wordrider.utilities.Utils;

public final class UndoAction
extends TextAreaAction {
    private static final UndoAction instance = new UndoAction();
    private static final String CODE = "UndoAction";

    public static final UndoAction getInstance() {
        return instance;
    }

    public UndoAction() {
        super(CODE, KeyStroke.getKeyStroke(90, 2), "undo.gif");
        this.setEnabled(false);
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        RiderArea riderArea = this.getRiderArea(actionEvent);
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            try {
                undoManager.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                Utils.processException(cannotUndoException);
            }
            this.updateUndoState(riderArea);
            RedoAction.getInstance().updateRedoState(riderArea);
        }
    }

    public final void updateUndoState(JTextComponent jTextComponent) {
        RiderArea riderArea = (RiderArea)jTextComponent;
        if (riderArea != null) {
            UndoManager undoManager = riderArea.getUndoManager();
            if (undoManager != null) {
                this.setEnabled(undoManager.canUndo());
            }
        } else {
            this.setEnabled(false);
        }
    }
}

