/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Properties;
import net.wordrider.utilities.Utils;

public class AppPrefs {
    private static String DEFAULT_PROPERTIES = "wordrider.properties";
    private static final String CLASS_EXT = ".class";
    private static final String JAR_SEPARATOR = "!/";
    private static final String URL_SEPARATOR = "/";
    private static final String CLASS_SEPARATOR = ".";
    private static final String FILE_PREFIX = "file:";
    private static final Properties properties = AppPrefs.loadDefaultProperties();
    private static String propertiesFile;
    private static final String DEFAULT_LANG_CODE = "EN";
    private static final String DEFAULT_NOT_FOUND = "Not found!";
    private static final String LANG_EXTENSION = ".properties";
    private static final String MNEMONIC_EXTENSION = ".mnemonic";
    private static final String HINT_EXTENSION = ".hint";
    private static Properties language;
    private static final String selectedLanguageKey = "selLanguage";
    private static String appPath;
    public static final String PROXY_USE = "settings.proxy.proxy";
    public static final String PROXY_URL = "settings.proxy.url";
    public static final String PROXY_SAVEPASSWORD = "settings.proxy.savepassword";
    public static final String PROXY_PORT = "settings.proxy.port";
    public static final String PROXY_LOGIN = "settings.proxy.login";
    public static final String PROXY_USERNAME = "settings.proxy.username";
    public static final String PROXY_PASSWORD = "settings.proxy.password";

    public static final String getSelectedLanguageCode() {
        return AppPrefs.getProperty(selectedLanguageKey, DEFAULT_LANG_CODE);
    }

    public static final void setSelectedLanguageCode(String string) {
        AppPrefs.storeProperty(selectedLanguageKey, string);
    }

    private static Properties loadLangProperties() {
        return AppPrefs.loadProperties("resources/languages/" + AppPrefs.getSelectedLanguageCode() + LANG_EXTENSION, true);
    }

    public static final void reloadLangProperties() {
        language = AppPrefs.loadLangProperties();
    }

    private static Properties loadDefaultProperties() {
        propertiesFile = AppPrefs.getAppPath() + File.separator + DEFAULT_PROPERTIES;
        return AppPrefs.loadProperties(propertiesFile, false);
    }

    public static final Properties loadProperties(String string, boolean bl) {
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            inputStream = !bl ? new FileInputStream(string) : ((URLClassLoader)AppPrefs.class.getClassLoader()).getResourceAsStream(string);
            properties.load(inputStream);
            inputStream.close();
            return properties;
        }
        catch (IOException iOException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException2) {
                Utils.processException(iOException2);
            }
            if (AppPrefs.isWindows()) {
                Utils.log(3, "Couldn't load properties:" + string + " This is fatal error. Reinstal application may fix this problem.");
            }
            Utils.processException(iOException);
            return properties;
        }
    }

    public static final String getLabel(String string) {
        return language.getProperty(string, DEFAULT_NOT_FOUND);
    }

    public static final String getHint(String string) {
        return language.getProperty(string + HINT_EXTENSION, string);
    }

    public static final String getLabel(String string, Object object) {
        return AppPrefs.getLabel(string, new Object[]{object == null ? "" : object});
    }

    public static final String getLabel(String string, Object[] objectArray) {
        return new MessageFormat(language.getProperty(string, DEFAULT_NOT_FOUND)).format(objectArray);
    }

    public static final char getMnemonic(String string) {
        String string2 = language.getProperty(string + MNEMONIC_EXTENSION, "");
        return string2.length() > 0 ? string2.charAt(0) : (char)'\u0000';
    }

    public static final String getProperty(String string, String string2) {
        return properties.getProperty(string, string2);
    }

    public static final int getProperty(String string, int n) {
        try {
            return Integer.parseInt(properties.getProperty(string, String.valueOf(n)));
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static final boolean getProperty(String string, boolean bl) {
        String string2 = properties.getProperty(string, String.valueOf(bl));
        return Boolean.valueOf(string2);
    }

    public static final Object removeProperty(String string) {
        return properties.remove(string);
    }

    public static final void store() {
        if (!AppPrefs.getProperty(PROXY_SAVEPASSWORD, false)) {
            properties.remove(PROXY_PASSWORD);
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(propertiesFile);
            properties.store(fileOutputStream, "WordRider 0.55" + System.getProperty("line.separator", "\n") + "#WordRider properties. Only for experienced users.");
            ((OutputStream)fileOutputStream).close();
        }
        catch (IOException iOException) {
            try {
                if (fileOutputStream != null) {
                    ((OutputStream)fileOutputStream).close();
                }
            }
            catch (IOException iOException2) {
                Utils.processException(iOException2);
            }
            Utils.log(3, "Couldn't save app properties. This is a fatal error. Please reinstall the application.");
            Utils.processException(iOException);
        }
        Utils.log(1, "Properties were saved successfuly");
    }

    public static final void storeProperty(String string, boolean bl) {
        properties.setProperty(string, String.valueOf(bl));
    }

    public static final void storeProperty(String string, String string2, boolean bl) {
        properties.setProperty(string, string2);
        if (bl) {
            AppPrefs.store();
        }
    }

    public static final void storeProperty(String string, String string2) {
        properties.setProperty(string, string2);
    }

    public static boolean isWindows() {
        String string = System.getProperty("os.name");
        return string == null || string.startsWith("Windows");
    }

    public static String getAppPath() {
        if (appPath != null) {
            return appPath;
        }
        int n = 0;
        String string = null;
        String string2 = AppPrefs.class.getName();
        int n2 = string2.length() + CLASS_EXT.length();
        int n3 = string2.lastIndexOf(CLASS_SEPARATOR);
        boolean bl = Utils.isDefinedForLog(0);
        if (n3 > -1) {
            string2 = string2.substring(n3 + 1);
        }
        if (bl) {
            Utils.log(0, "ClassName " + string2 + CLASS_EXT);
        }
        URL uRL = AppPrefs.class.getResource(string2 + CLASS_EXT);
        if (bl) {
            Utils.log(0, "URL " + uRL);
        }
        if (uRL != null) {
            string = uRL.toString();
            if (bl) {
                Utils.log(0, "Url string1 " + string);
            }
            if ((n3 = string.indexOf(JAR_SEPARATOR)) > -1) {
                string = string.substring(0, n3);
                if (bl) {
                    Utils.log(0, "URL String2 " + string);
                }
                n = string.lastIndexOf(URL_SEPARATOR) + 1;
            } else {
                n = string.length() - n2;
            }
            n3 = string.lastIndexOf(FILE_PREFIX);
            n3 = n3 > -1 ? (n3 += FILE_PREFIX.length() + (AppPrefs.isWindows() ? 1 : 0)) : 0;
            string = string.substring(n3, n);
            if (Utils.isDefinedForLog(0)) {
                Utils.log(0, "App Path is " + string);
            }
            String string3 = "";
            try {
                string3 = URLDecoder.decode(string, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Utils.processException(unsupportedEncodingException);
            }
            appPath = string3;
            return appPath;
        }
        appPath = "";
        return "";
    }

    static {
        language = AppPrefs.loadLangProperties();
        appPath = null;
    }
}

