/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core;

import java.awt.BorderLayout;
import java.awt.DisplayMode;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.ExitAction;
import net.wordrider.core.actions.OpenFileAction;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.gui.LookAndFeels;
import net.wordrider.plugintools.BreakpointList;
import net.wordrider.plugintools.CharacterList;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class MainAppFrame
extends JFrame {
    private JPanel rootPanel;
    private ManagerDirector mainPanelManager;

    public MainAppFrame() throws HeadlessException {
        ImageIcon imageIcon = Swinger.getIcon("011.png");
        if (imageIcon != null) {
            this.setIconImage(imageIcon.getImage());
        }
        DisplayMode displayMode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        this.setSize(displayMode.getWidth(), displayMode.getHeight());
        this.setTitle("WordRider 0.55" + (Utils.isDefinedForLog(0) ? " debug" : ""));
        this.setDefaultCloseOperation(3);
        this.setContentPane(this.getMainPanel());
    }

    protected final JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainAppFrame.this.mainPanelManager.getStatusbarManager().specialKeyStatusChanged();
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(144, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        keyStroke = KeyStroke.getKeyStroke(20, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    public final void init(String string) {
        this.getManagerDirector();
        if (string != null) {
            OpenFileAction.getInstance().open(new File(string));
        } else {
            this.mainPanelManager.getAreaManager().openFileInstance();
        }
        this.mainPanelManager.getPluginToolsManager().addPluginTool(new CharacterList());
        this.mainPanelManager.getPluginToolsManager().addPluginTool(new BreakpointList());
        this.mainPanelManager.getAreaManager().grabActiveFocus();
        this.setExtendedState(6);
        this.setVisible(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String[] stringArray = new String[]{"FileChooser.lookInLabelText", "FileChooser.saveInLabelText", "FileChooser.fileNameLabelText", "FileChooser.filesOfTypeLabelMnemonic", "FileChooser.filesOfTypeLabelText", "FileChooser.upFolderToolTipText", "FileChooser.upFolderAccessibleName", "FileChooser.homeFolderToolTipText", "FileChooser.homeFolderAccessibleName", "FileChooser.newFolderToolTipText", "FileChooser.newFolderAccessibleName", "FileChooser.listViewButtonToolTipText", "FileChooser.listViewButtonAccessibleName", "FileChooser.detailsViewButtonToolTipText", "FileChooser.detailsViewButtonAccessibleName", "FileChooser.fileNameHeaderText", "FileChooser.fileSizeHeaderText", "FileChooser.fileTypeHeaderText", "FileChooser.fileDateHeaderText", "FileChooser.fileAttrHeaderText", "FileChooser.cancelButtonText", "FileChooser.cancelButtonToolTipText", "FileChooser.deleteFileButtonText", "FileChooser.filesLabelText", "FileChooser.foldersLabelText", "FileChooser.newFolderButtonText", "FileChooser.openButtonText", "FileChooser.openButtonToolTipText", "FileChooser.openDialogTitleText", "FileChooser.pathLabelText", "FileChooser.renameFileButtonText", "FileChooser.saveButtonText", "FileChooser.saveButtonToolTipText", "FileChooser.saveDialogTitleText"};
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    UIManager.put(string, AppPrefs.getLabel(string));
                }
            }
        });
        if (!RiderStyles.isCorrectFont()) {
            Swinger.showErrorDialog(this, AppPrefs.getLabel("message.error.fontloadfailed", new Object[]{"Ti-92p.ttf", "Ti92Pluspc"}));
        }
    }

    private JPanel getMainPanel() {
        if (this.rootPanel == null) {
            this.rootPanel = new JPanel();
            this.rootPanel.setLayout(new BorderLayout());
        }
        return this.rootPanel;
    }

    public final ManagerDirector getManagerDirector() {
        if (this.mainPanelManager == null) {
            this.mainPanelManager = new ManagerDirector(this, this.rootPanel);
        }
        return this.mainPanelManager;
    }

    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            ExitAction.getInstance().actionPerformed(null);
        }
    }

    static {
        LookAndFeels.loadLookAndFeelSettings();
    }
}

