/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.CheckVersion;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.dialogs.ConnectDialog;
import net.wordrider.dialogs.LoadingDialog;
import net.wordrider.utilities.BrowserControl;
import net.wordrider.utilities.Swinger;

public class CheckForNewVersion
extends CoreAction {
    private static final CheckForNewVersion INSTANCE = new CheckForNewVersion();
    private static final String CODE = "CheckForNewVersion";

    public static final CheckForNewVersion getInstance() {
        return INSTANCE;
    }

    private CheckForNewVersion() {
        super(CODE, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JFrame jFrame = CheckForNewVersion.getMainFrame();
        int n = new ConnectDialog(jFrame).getModalResult();
        if (n == 0) {
            LoadingDialog loadingDialog = new LoadingDialog(jFrame);
            CheckVersion checkVersion = new CheckVersion(loadingDialog);
            checkVersion.start();
            loadingDialog.setVisible(true);
            switch ((Integer)checkVersion.get()) {
                case 0: {
                    int n2 = Swinger.getChoice(jFrame, AppPrefs.getLabel("message.connect.newVersion"));
                    if (n2 != 0) break;
                    BrowserControl.showHomepage();
                    break;
                }
                case 16: {
                    Swinger.showErrorDialog(jFrame, AppPrefs.getLabel("message.connect.exception", checkVersion.getErrorMessage()));
                    break;
                }
                case 128: {
                    Swinger.showErrorDialog(jFrame, AppPrefs.getLabel("message.connect.noInetAvailable"));
                    break;
                }
                default: {
                    Swinger.showInformationDialog(jFrame, AppPrefs.getLabel("message.connect.sameVersion"));
                }
            }
        }
    }
}

