/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.LoadingDialog;
import net.wordrider.utilities.SwingWorker;
import net.wordrider.utilities.Utils;

final class CheckVersion
extends SwingWorker {
    public static final int CONNECT_NEW_VERSION = 0;
    public static final int CONNECT_SAME_VERSION = 8;
    public static final int CONNECT_ERROR_EXCEPTION = 16;
    public static final int CONNECT_ERROR_INETCONNECTION_NOTAVAILABLE = 128;
    private String errorMessage = "";
    private LoadingDialog dialogToClose;
    private static final String PARAM_VERSION = "version";

    public CheckVersion(LoadingDialog loadingDialog) {
        this.dialogToClose = loadingDialog;
    }

    public final Object construct() {
        Utils.logDebug("--Checking version start--");
        if (AppPrefs.getProperty("settings.proxy.proxy", false)) {
            System.setProperty("proxySet", "true");
            System.setProperty("https.proxyHost", AppPrefs.getProperty("settings.proxy.url", "localhost"));
            System.setProperty("https.proxyPort", AppPrefs.getProperty("settings.proxy.port", "8080"));
            System.setProperty("proxyHost", AppPrefs.getProperty("settings.proxy.url", "localhost"));
            System.setProperty("proxyPort", AppPrefs.getProperty("settings.proxy.port", "8080"));
            if (AppPrefs.getProperty("settings.proxy.login", false)) {
                Authenticator.setDefault(new HttpAuthenticateProxy(AppPrefs.getProperty("settings.proxy.username", ""), Utils.generateXorString(AppPrefs.getProperty("settings.proxy.password", ""))));
            }
        } else {
            System.setProperty("proxySet", "false");
        }
        return new Integer(this.checkIt());
    }

    public final void finished() {
        super.finished();
        this.dialogToClose.dispose();
        Utils.logDebug("--Checking version end--");
    }

    public final String getErrorMessage() {
        return this.errorMessage;
    }

    private final int checkIt() {
        HttpURLConnection httpURLConnection = null;
        this.dialogToClose.setStatusText(AppPrefs.getLabel("message.connect.status.connecting"));
        try {
            httpURLConnection = (HttpURLConnection)new URL("http://wordrider.net/check.php").openConnection();
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            DataOutputStream dataOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            Utils.log(0, "Connected to WordRider.net, Writing params");
            dataOutputStream.write(Utils.addParam("", PARAM_VERSION, "WordRider 0.55").getBytes());
            dataOutputStream.close();
            Utils.log(0, "reading Response");
            this.dialogToClose.setStatusText(AppPrefs.getLabel("message.connect.status.checking"));
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
            String string = bufferedReader.readLine();
            bufferedReader.close();
            Utils.log(0, "disconnecting");
            this.dialogToClose.setStatusText(AppPrefs.getLabel("message.connect.status.disconnect"));
            httpURLConnection.disconnect();
            if (string != null && string.startsWith("#") && string.endsWith("#") && !string.toLowerCase().equals("#" + "WordRider 0.55".toLowerCase() + "#")) {
                return 0;
            }
        }
        catch (UnknownHostException unknownHostException) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return 128;
        }
        catch (IOException iOException) {
            this.errorMessage = iOException.getMessage();
            Utils.processException(iOException);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return 16;
        }
        return 8;
    }

    private static class HttpAuthenticateProxy
    extends Authenticator {
        private String proxyUsername;
        private String proxyPassword;

        public HttpAuthenticateProxy(String string, String string2) {
            this.proxyUsername = string;
            this.proxyPassword = string2;
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.proxyUsername, this.proxyPassword.toCharArray());
        }
    }
}

