/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.actions.CoreAction;
import net.wordrider.core.actions.IFileType;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.ti89.InvalidDataTypeException;
import net.wordrider.ti89.NotSupportedFileException;
import net.wordrider.ti89.TITextFileReader;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class OpenFileAction
extends CoreAction {
    private static final OpenFileAction instance = new OpenFileAction();
    public static final String LASTOPENFOLDER_KEY = "lastOpenFolder";
    private static final String CODE = "OpenFileAction";

    public static OpenFileAction getInstance() {
        return instance;
    }

    private OpenFileAction() {
        super(CODE, KeyStroke.getKeyStroke(79, 2), "open.gif");
    }

    private File getOpenFileDialog() {
        File file = new File(AppPrefs.getProperty(LASTOPENFOLDER_KEY, ""));
        JFileChooser jFileChooser = new JFileChooser(file);
        jFileChooser.setDialogTitle(AppPrefs.getLabel("OpenFileAction.dialog.title"));
        jFileChooser.setFileFilter(new File89tFilter());
        jFileChooser.showOpenDialog(OpenFileAction.getMainFrame());
        return jFileChooser.getSelectedFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean open(File file) {
        boolean bl;
        File file2;
        File file3 = file2 = file == null ? this.getOpenFileDialog() : file;
        if (file2 == null) {
            return false;
        }
        if (!file2.isFile() || !file2.exists()) {
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), AppPrefs.getLabel("message.error.FNF", file2.getAbsolutePath()));
            return false;
        }
        AppPrefs.storeProperty(LASTOPENFOLDER_KEY, file2.getAbsolutePath());
        AreaManager areaManager = OpenFileAction.getAreaManager();
        FileInstance fileInstance = (FileInstance)areaManager.isFileAlreadyOpened(file2);
        if (fileInstance != null) {
            if (Swinger.getChoice(OpenFileAction.getMainFrame(), AppPrefs.getLabel("message.confirm.FAE")) != 0) return false;
            bl = true;
        } else {
            bl = false;
        }
        try {
            final TITextFileReader tITextFileReader = new TITextFileReader();
            tITextFileReader.openFromFile(file2);
            if (!bl) {
                fileInstance = new FileInstance(file2, tITextFileReader.getTextFileInfo());
                areaManager.openFileInstance(fileInstance);
            }
            final RiderArea riderArea = (RiderArea)fileInstance.getTextComponent();
            riderArea.noModifyUpdate(true);
            riderArea.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Document document = riderArea.getDocument();
                int n = document.getLength();
                if (n > 0) {
                    document.remove(0, n);
                }
                document.insertString(0, AppPrefs.getLabel("message.loading"), null);
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
            }
            riderArea.getUndoManager().discardAllEdits();
            riderArea.noModifyUpdate(false);
            if (bl) {
                areaManager.setActivateFileInstance(fileInstance);
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        riderArea.getKit().setTextRiderText(riderArea, tITextFileReader.getContent(), file2.getParent());
                    }
                    catch (BadLocationException badLocationException) {
                        Utils.processException(badLocationException);
                        Swinger.showErrorDialog(CoreAction.getMainFrame(), badLocationException.getMessage());
                        return;
                    }
                }
            });
            return true;
        }
        catch (InvalidDataTypeException invalidDataTypeException) {
            Utils.log(2, invalidDataTypeException.getMessage());
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), invalidDataTypeException.getMessage());
            boolean bl2 = false;
            return bl2;
        }
        catch (NotSupportedFileException notSupportedFileException) {
            Utils.log(2, notSupportedFileException.getMessage());
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), notSupportedFileException.getMessage());
            boolean bl3 = false;
            return bl3;
        }
        catch (IOException iOException) {
            Utils.processException(iOException);
            Swinger.showErrorDialog(OpenFileAction.getMainFrame(), AppPrefs.getLabel("message.error.reading", iOException.getMessage()));
            boolean bl4 = false;
            return bl4;
        }
        finally {
            areaManager.getActiveFileInstance().getTextComponent().setCursor(Cursor.getDefaultCursor());
        }
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        this.open(null);
    }

    public static final class File89tFilter
    extends FileFilter
    implements IFileType {
        private static final String FILE_EXTENSION = "89t";

        public final String getDescription() {
            return AppPrefs.getLabel("OpenFileAction.dialog.filter89");
        }

        public String getExtension() {
            return FILE_EXTENSION;
        }

        public final boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = Utils.getExtension(file);
            if (string != null) {
                return string.equals(FILE_EXTENSION);
            }
            return false;
        }
    }
}

