/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import net.wordrider.area.RiderStyles;
import net.wordrider.ti89.TIImageDecoder;
import net.wordrider.ti89.TITextFileInfo;

final class TextRiderProcess {
    private static final String[] txtriderTags = new String[]{"#U", "#V", "#I", "#N", "#S", "#E", "#W"};
    private static final String[] txtriderParagraphTags = new String[]{"#1", "#2", "#3", "&L", "&R", "&C", "&\\", "&,", "&;", "&.", "&-", "&=", "&E", "&P"};
    private final boolean[] paarAttributes = new boolean[txtriderTags.length];
    private final short[] attributesMore = new short[3];
    private static final byte P_ALIGNMENT = 0;
    private static final byte P_SIZE = 1;
    private static final byte P_MARGIN = 2;
    private static final byte P_UNDERLINE = 0;
    private static final byte P_VECTOR = 1;
    private static final byte P_INVERT = 2;
    private static final byte P_UNDERLINE_DOTTED = 3;
    private static final byte P_STRIKETHROUGHT = 4;
    private static final byte P_EXPOSANT = 5;
    private static final byte P_WORDWRAP = 6;
    private static final byte P_SIZEMINI = 0;
    private static final byte P_SIZENORMAL = 1;
    private static final byte P_SIZEMAXI = 2;
    private static final byte P_ALIGNLEFT = 3;
    private static final byte P_ALIGNRIGHT = 4;
    private static final byte P_ALIGNCENTER = 5;
    private static final byte P_MARGIN0 = 6;
    private static final byte P_MARGIN10 = 7;
    private static final byte P_MARGIN20 = 8;
    private static final byte P_MARGIN30 = 9;
    private static final byte P_LINESEPARATOR = 10;
    private static final byte P_DOUBLELINE = 11;
    private static final byte P_PRETTYPRINT = 12;
    private static final byte P_PICTURE = 13;
    private static final String LINE_SEPARATOR_TEXT = "\n";
    private static final String LINE_SEPARATOR_FILE = "\r ";
    private static final String tabulator = "   ";
    private String activeLineSeparator = "\n";
    private StringBuffer buffer;
    private boolean prettyPrint = false;
    private AttributeSet attr;
    private TITextFileInfo info;

    TextRiderProcess() {
    }

    private void initProcess() {
        for (int i = 0; i < this.paarAttributes.length; ++i) {
            this.paarAttributes[i] = false;
        }
        this.attributesMore[0] = 3;
        this.attributesMore[1] = 1;
        this.attributesMore[2] = 6;
    }

    public final String getTxtRiderTextForDocument(StyledDocument styledDocument, TITextFileInfo tITextFileInfo, boolean bl) throws BadLocationException {
        Element element = styledDocument.getDefaultRootElement();
        int n = element.getElementCount();
        this.activeLineSeparator = bl ? LINE_SEPARATOR_FILE : LINE_SEPARATOR_TEXT;
        this.buffer = new StringBuffer(styledDocument.getLength() + 50);
        this.info = tITextFileInfo;
        this.initProcess();
        for (int i = 0; i < n; ++i) {
            Element element2 = element.getElement(i);
            if (bl) {
                this.updateBookmark(element2);
            }
            if (!RiderStyles.isReadonlySection(element2)) {
                this.updateParagraphProperties(element2);
            }
            int n2 = element2.getElementCount();
            boolean bl2 = false;
            for (int j = 0; j < n2; ++j) {
                int n3;
                Element element3 = element2.getElement(j);
                if (this.updateComponents(element3, j == 0)) {
                    bl2 = true;
                    continue;
                }
                int n4 = element3.getStartOffset();
                String string = styledDocument.getText(n4, (n3 = element3.getEndOffset()) - n4);
                if (!string.equals(LINE_SEPARATOR_TEXT) && !string.equals("\n\r") && bl2) {
                    this.buffer.append(this.activeLineSeparator);
                }
                if (!this.prettyPrint && !bl2) {
                    this.updateCharacterAttributes(element3.getAttributes());
                }
                this.buffer.append(string);
            }
        }
        return this.updateResult(bl);
    }

    private boolean updateComponents(Element element, boolean bl) {
        return this.updateSingleLine(element, bl) || this.updateDoubleLine(element, bl) || this.updateImageComponent(element, bl);
    }

    private void updateParagraphProperties(Element element) {
        this.prettyPrint = this.updatePrettyPrint(element);
        if (!this.prettyPrint) {
            this.attr = element.getAttributes();
            this.updateMargin(this.attr);
            this.updateAligment(this.attr);
        }
    }

    private void updateCharacterAttributes(AttributeSet attributeSet) {
        this.updatePaarTag(5, RiderStyles.isExposant(attributeSet));
        this.updateFontSize(attributeSet);
        this.updatePaarTag(6, RiderStyles.isWordWrap(attributeSet));
        this.updatePaarTag(0, RiderStyles.isUnderLine(attributeSet));
        this.updatePaarTag(2, RiderStyles.isInvert(attributeSet));
        this.updatePaarTag(3, RiderStyles.isUnderLineDotted(attributeSet));
        this.updatePaarTag(4, RiderStyles.isStrikeOut(attributeSet));
        this.updatePaarTag(1, RiderStyles.isVector(attributeSet));
    }

    private String updateResult(boolean bl) {
        if (bl) {
            this.buffer.deleteCharAt(this.buffer.length() - 1);
            if (this.buffer.charAt(this.buffer.length() - 1) == '\n') {
                this.buffer.append(' ');
            }
            String string = this.buffer.toString().replaceAll("\n\r", LINE_SEPARATOR_FILE).replaceAll("\t", tabulator);
            this.buffer = null;
            return string;
        }
        String string = this.buffer.toString();
        this.buffer = null;
        return string;
    }

    private void updateBookmark(Element element) {
        this.buffer.append(RiderStyles.isBookmark(element) ? (char)'\f' : ' ');
    }

    private boolean updatePrettyPrint(Element element) {
        boolean bl = RiderStyles.isMath(element);
        if (bl) {
            this.buffer.append(txtriderParagraphTags[12]);
        }
        return bl;
    }

    private final void updateAligment(AttributeSet attributeSet) {
        short s;
        switch (RiderStyles.getAligment(attributeSet)) {
            case 0: {
                s = 3;
                break;
            }
            case 1: {
                s = 5;
                break;
            }
            case 2: {
                s = 4;
                break;
            }
            default: {
                s = 3;
            }
        }
        if (this.attributesMore[0] != s) {
            this.attributesMore[0] = s;
            this.buffer.append(txtriderParagraphTags[s]);
        }
    }

    private final void updateMargin(AttributeSet attributeSet) {
        short s;
        switch (RiderStyles.getMargin(attributeSet)) {
            case 0: {
                s = 6;
                break;
            }
            case 10: {
                s = 7;
                break;
            }
            case 20: {
                s = 8;
                break;
            }
            case 30: {
                s = 9;
                break;
            }
            default: {
                s = 6;
            }
        }
        if (this.attributesMore[2] != s) {
            this.attributesMore[2] = s;
            this.buffer.append(txtriderParagraphTags[s]);
        }
    }

    private final void updateFontSize(AttributeSet attributeSet) {
        short s;
        switch (RiderStyles.getFontSize(attributeSet)) {
            case 13: {
                s = 1;
                break;
            }
            case 16: {
                s = 2;
                break;
            }
            case 11: {
                s = 0;
                break;
            }
            default: {
                s = 1;
            }
        }
        if (this.attributesMore[1] != s) {
            this.attributesMore[1] = s;
            this.buffer.append(txtriderParagraphTags[s]);
        }
    }

    private final boolean updateSingleLine(Element element, boolean bl) {
        if (RiderStyles.isComponentLine(element, 0)) {
            if (!bl) {
                this.buffer.append(this.activeLineSeparator);
            }
            this.buffer.append(txtriderParagraphTags[10]);
            return true;
        }
        return false;
    }

    private final boolean updateDoubleLine(Element element, boolean bl) {
        if (RiderStyles.isComponentLine(element, 1)) {
            if (!bl) {
                this.buffer.append(this.activeLineSeparator);
            }
            this.buffer.append(txtriderParagraphTags[11]);
            return true;
        }
        return false;
    }

    private final String generateImageDesc(TIImageDecoder tIImageDecoder) {
        switch (this.info.getPictureProcessingType()) {
            case 0: {
                return tIImageDecoder.getFileInfo().getFolderName() + "\\" + tIImageDecoder.getFileInfo().getVarName();
            }
            case 1: {
                int n = tIImageDecoder.getImagePath().lastIndexOf(92) + 1;
                if (n != 0) {
                    return tIImageDecoder.getImagePath().substring(n) + "\\" + tIImageDecoder.getFileInfo().getVarName();
                }
                return null;
            }
            case 2: {
                return this.info.getPictureFolder() + "\\" + tIImageDecoder.getFileInfo().getVarName();
            }
            case 4: {
                return this.info.getFolderName() + "\\" + tIImageDecoder.getFileInfo().getVarName();
            }
        }
        return null;
    }

    private final boolean updateImageComponent(Element element, boolean bl) {
        String string;
        TIImageDecoder tIImageDecoder = RiderStyles.isSupportedImage(element);
        if (tIImageDecoder != null && (string = this.generateImageDesc(tIImageDecoder)) != null) {
            if (!bl) {
                this.buffer.append(this.activeLineSeparator);
            }
            this.buffer.append(txtriderParagraphTags[13]).append(string);
            return true;
        }
        return false;
    }

    private final void updatePaarTag(int n, boolean bl) {
        if (bl ^ this.paarAttributes[n]) {
            this.paarAttributes[n] = bl;
            this.buffer.append(txtriderTags[n]);
        }
    }
}

