/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.wordrider.area.RiderArea;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.ManagerDirector;
import net.wordrider.core.managers.RecentFilesManager;
import net.wordrider.core.managers.TabManager;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IInformedTab;

public final class AreaManager
extends TabManager {
    private final ManagerDirector director;
    private final Collection areaChangelisteners = new ArrayList(4);
    private final Collection fileStatusListeners = new ArrayList(1);
    private final RecentFilesManager recentFilesManager;

    public AreaManager(ManagerDirector managerDirector) {
        this.director = managerDirector;
        this.recentFilesManager = new RecentFilesManager(managerDirector.getMenuManager());
        this.fileStatusListeners.add(this.recentFilesManager);
    }

    public final IFileInstance getActiveFileInstance() {
        return (IFileInstance)super.getActiveInstance();
    }

    public final IFileInstance isFileAlreadyOpened(File file) {
        Iterator iterator = this.runningInstancesIDs.values().iterator();
        while (iterator.hasNext()) {
            IFileInstance iFileInstance = (IFileInstance)iterator.next();
            if (!file.equals(iFileInstance.getFile())) continue;
            return iFileInstance;
        }
        return null;
    }

    public final void openFileInstance() {
        this.openFileInstance(new FileInstance());
    }

    public final void openFileInstance(FileInstance fileInstance) {
        this.registerNewOne(fileInstance);
        Iterator iterator = this.fileStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IFileChangeListener)iterator.next()).fileWasOpened(fileInstance.getFile());
        }
    }

    protected final void deactivateInstance(Integer n) {
        super.deactivateInstance(n);
        this.director.getPluginToolsManager().selectedAreaChanged(null);
        Iterator iterator = this.areaChangelisteners.iterator();
        while (iterator.hasNext()) {
            IAreaChangeListener iAreaChangeListener = (IAreaChangeListener)iterator.next();
            iAreaChangeListener.selectedAreaChanged(null);
        }
    }

    protected final void activateInstance(Integer n) {
        super.activateInstance(n);
        IFileInstance iFileInstance = this.getActiveFileInstance();
        Iterator iterator = this.areaChangelisteners.iterator();
        while (iterator.hasNext()) {
            IAreaChangeListener iAreaChangeListener = (IAreaChangeListener)iterator.next();
            iAreaChangeListener.selectedAreaChanged(iFileInstance);
        }
    }

    public final void setTabTitle(IInformedTab iInformedTab) {
        int n = this.tabbedPane.indexOfComponent(iInformedTab.getComponent());
        this.tabbedPane.setTitleAt(n, iInformedTab.getTabName());
    }

    final void addAreaChangeListener(IAreaChangeListener iAreaChangeListener) {
        this.areaChangelisteners.add(iAreaChangeListener);
    }

    final void removeAreaChangeListener(IAreaChangeListener iAreaChangeListener) {
        this.areaChangelisteners.remove(iAreaChangeListener);
    }

    public final Collection getOpenedInstances() {
        return new LinkedList(this.runningInstancesIDs.values());
    }

    public final Collection getModifiedInstances() {
        ArrayList<IFileInstance> arrayList = new ArrayList<IFileInstance>();
        Iterator iterator = this.getOpenedInstances().iterator();
        while (iterator.hasNext()) {
            IFileInstance iFileInstance = (IFileInstance)iterator.next();
            if (!((RiderArea)iFileInstance.getTextComponent()).isModified()) continue;
            arrayList.add(iFileInstance);
        }
        return arrayList;
    }

    public final void setActivateFileInstance(FileInstance fileInstance) {
        this.tabbedPane.setSelectedComponent(fileInstance.getComponent());
    }

    public final void closeInstanceHard(FileInstance fileInstance) {
        File file = fileInstance.getFile();
        this.closeHard((Integer)this.runningTabs.get(fileInstance.getComponent()));
        Iterator iterator = this.fileStatusListeners.iterator();
        while (iterator.hasNext()) {
            ((IFileChangeListener)iterator.next()).fileWasClosed(file);
        }
    }

    public final void closeActiveInstance() {
        IFileInstance iFileInstance = this.getActiveFileInstance();
        if (iFileInstance != null) {
            this.closeSoft(this.activeInstanceID);
            File file = iFileInstance.getFile();
            Iterator iterator = this.fileStatusListeners.iterator();
            while (iterator.hasNext()) {
                ((IFileChangeListener)iterator.next()).fileWasClosed(file);
            }
        }
    }

    public RecentFilesManager getRecentFilesManager() {
        return this.recentFilesManager;
    }

    public void grabActiveFocus() {
        IFileInstance iFileInstance = this.getActiveFileInstance();
        if (iFileInstance != null) {
            iFileInstance.getTextComponent().grabFocus();
        }
    }

    public void updateTabTitle() {
        this.setTabTitle((IInformedTab)this.getActiveInstance());
    }
}

