/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.managers.interfaces.IHideAble;
import net.wordrider.core.managers.interfaces.IRiderManager;
import net.wordrider.utilities.Utils;

public final class StatusbarManager
implements IRiderManager,
CaretListener,
IAreaChangeListener,
PropertyChangeListener,
IHideAble {
    public static final String MODIFIED_PROPERTY = "modified";
    private final JPanel statusPanel;
    private static final String LINE_PROPERTY = "linePosition";
    private static final String OVERTYPE_PROPERTY = "overtype";
    private JTextComponent editor;
    private final Map subSections = new LinkedHashMap(9);
    private static final Font font = new Font("SansSerif", 0, 11);

    public StatusbarManager() {
        this.statusPanel = new JPanel();
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 0));
        this.statusPanel.setSize(new Dimension(10, 16));
        this.statusPanel.setPreferredSize(new Dimension(10, 16));
        this.statusPanel.setVisible(AppPrefs.getProperty("net.wordrider.gui.showStatusbar", true));
        this.init();
    }

    private void init() {
        this.clear();
    }

    private void addSeparator(String string, int n) {
        this.removeSection(string);
        this.subSections.put(string, new PanelItem("", null, n, true));
        this.repaintStatusPanel();
    }

    private void addSection(String string, String string2, String string3, int n) {
        this.removeSection(string);
        this.subSections.put(string, new PanelItem(string2, string3, n, false));
        this.repaintStatusPanel();
    }

    private void removeSection(String string) {
        if (this.subSections.containsKey(string)) {
            this.subSections.remove(string);
            this.repaintStatusPanel();
        }
    }

    private void display(String string, String string2) {
        PanelItem panelItem = (PanelItem)this.subSections.get(string);
        panelItem.setOptionalLabel(string2);
    }

    private void display(String string, String string2, String string3) {
        PanelItem panelItem = (PanelItem)this.subSections.get(string);
        panelItem.setOptionalLabel(string2, string3);
    }

    private void repaintStatusPanel() {
        this.clear();
        PanelItem panelItem = null;
        Iterator iterator = this.subSections.values().iterator();
        while (iterator.hasNext()) {
            panelItem = (PanelItem)iterator.next();
            Dimension dimension = new Dimension(panelItem.getLength(), 14);
            JPanel jPanel = new JPanel(null);
            jPanel.add(panelItem.getComponent());
            jPanel.setPreferredSize(dimension);
            if (!panelItem.isSeparator()) {
                jPanel.setMinimumSize(dimension);
            }
            this.statusPanel.add(jPanel);
        }
        this.statusPanel.validate();
    }

    private void clear() {
        if (this.statusPanel != null) {
            this.statusPanel.removeAll();
            this.statusPanel.validate();
            this.statusPanel.repaint();
        }
    }

    public void displayFilePath(String string) {
        this.display("fileName", Utils.shortenFileName(string, 50), string);
    }

    private void displayOvertype(Boolean bl) {
        this.display(OVERTYPE_PROPERTY, bl != null && bl != false ? AppPrefs.getLabel("statusbar.rewrite") : AppPrefs.getLabel("statusbar.insert"));
    }

    public final Component getManagerComponent() {
        return this.statusPanel;
    }

    private void setCaretColumn(int n) {
        int n2 = 0;
        if (n != 0) {
            try {
                n2 = n - Utilities.getRowStart(this.editor, n);
            }
            catch (BadLocationException badLocationException) {
                Utils.processException(badLocationException);
            }
        }
        this.display("column", String.valueOf(n2 + 1));
    }

    public final void caretUpdate(final CaretEvent caretEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                StatusbarManager.this.setCaretColumn(caretEvent.getDot());
            }
        });
    }

    private void displayLineNumber(String string) {
        this.display("line", string);
    }

    private final void displayModified(Boolean bl) {
        this.display(MODIFIED_PROPERTY, bl != null && bl != false ? AppPrefs.getLabel("statusbar.modified") : "");
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(LINE_PROPERTY)) {
            this.displayLineNumber(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals(MODIFIED_PROPERTY)) {
            this.displayModified((Boolean)propertyChangeEvent.getNewValue());
            MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().updateTabTitle();
        } else if (propertyChangeEvent.getPropertyName().equals(OVERTYPE_PROPERTY)) {
            this.displayOvertype((Boolean)propertyChangeEvent.getNewValue());
        }
    }

    public final void specialKeyStatusChanged() {
        this.display("capslock", StatusbarManager.getKeyStatus(20) ? AppPrefs.getLabel("statusbar.caps") : "");
        this.display("numlock", StatusbarManager.getKeyStatus(144) ? AppPrefs.getLabel("statusbar.num") : "");
    }

    private static boolean getKeyStatus(int n) {
        try {
            return Toolkit.getDefaultToolkit().getLockingKeyState(n);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return false;
        }
    }

    public final void selectedAreaChanged(IFileInstance iFileInstance) {
        this.clear();
        if (iFileInstance != null && this.isVisible()) {
            this.addSection("fileName", "", "", 300);
            this.addSection("line", AppPrefs.getLabel("statusbar.linenumber") + " ", AppPrefs.getLabel("statusbar.hint.linePosition"), 70);
            this.addSection("column", AppPrefs.getLabel("statusbar.column") + " ", AppPrefs.getLabel("statusbar.hint.columnPosition"), 70);
            this.addSeparator("Separator1", 130);
            this.addSection(OVERTYPE_PROPERTY, "", AppPrefs.getLabel("statusbar.hint.overtype"), 60);
            this.addSection(MODIFIED_PROPERTY, "", AppPrefs.getLabel("statusbar.hint.modified"), 60);
            this.addSeparator("Separator2", 160);
            this.addSection("capslock", "", AppPrefs.getLabel("statusbar.hint.capslock"), 35);
            this.addSection("numlock", "", AppPrefs.getLabel("statusbar.hint.numlock"), 30);
            this.displayFilePath(iFileInstance.getFile() == null ? AppPrefs.getLabel("statusbar.notsaved") : iFileInstance.getFile().getAbsolutePath());
            if (!iFileInstance.getTextComponent().equals(this.editor)) {
                if (this.editor != null) {
                    this.editor.removeCaretListener(this);
                    this.editor.removePropertyChangeListener(MODIFIED_PROPERTY, this);
                    this.editor.removePropertyChangeListener(LINE_PROPERTY, this);
                    this.editor.removePropertyChangeListener(OVERTYPE_PROPERTY, this);
                }
                this.editor = iFileInstance.getTextComponent();
                this.editor.addCaretListener(this);
                this.editor.addPropertyChangeListener(LINE_PROPERTY, this);
                this.editor.addPropertyChangeListener(MODIFIED_PROPERTY, this);
                this.editor.addPropertyChangeListener(OVERTYPE_PROPERTY, this);
                this.setCaretColumn(this.editor.getCaretPosition());
                this.displayLineNumber("1");
                this.displayModified((Boolean)this.editor.getClientProperty(MODIFIED_PROPERTY));
                this.displayOvertype((Boolean)this.editor.getClientProperty(OVERTYPE_PROPERTY));
            }
            this.specialKeyStatusChanged();
        } else if (this.editor != null) {
            this.editor.removeCaretListener(this);
            this.editor = null;
        }
    }

    public final boolean isVisible() {
        return this.statusPanel.isVisible();
    }

    public final void setVisible(boolean bl) {
        if (bl) {
            this.statusPanel.setVisible(true);
            this.selectedAreaChanged(MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().getActiveFileInstance());
        } else {
            this.statusPanel.setVisible(false);
            this.selectedAreaChanged(null);
        }
        AppPrefs.storeProperty("net.wordrider.gui.showStatusbar", bl);
    }

    private final class PanelItem {
        private String staticLabel = "";
        private String optionalLabel = "";
        private int length;
        private Component component;
        private static final int COMPONENT_TYPE_LABEL = 0;
        private final int componentType = 0;
        private boolean separator = false;

        private PanelItem() {
        }

        public PanelItem(String string, String string2, int n, boolean bl) {
            this();
            this.separator = bl;
            this.staticLabel = string;
            this.length = n;
            JLabel jLabel = new JLabel(this.getComposedText());
            jLabel.setToolTipText(string2);
            this.component = jLabel;
            this.setLength(n);
            jLabel.setLocation(4, 0);
            jLabel.setFont(font);
        }

        public final Component getComponent() {
            return this.component;
        }

        public final int getLength() {
            return this.length;
        }

        public final String getStaticLabel() {
            return this.staticLabel;
        }

        public final void setLength(int n) {
            this.component.setSize(n, 14);
            this.length = n;
        }

        public final void setStaticLabel(String string) {
            this.staticLabel = string;
        }

        public final String getOptionalLabel() {
            return this.optionalLabel;
        }

        public final boolean isSeparator() {
            return this.separator;
        }

        public final void setOptionalLabel(String string, String string2) {
            this.optionalLabel = string;
            JLabel jLabel = (JLabel)this.component;
            jLabel.setText(this.getComposedText());
            jLabel.setToolTipText(string2);
        }

        public final void setOptionalLabel(String string) {
            this.optionalLabel = string;
            ((JLabel)this.component).setText(this.getComposedText());
        }

        private final String getComposedText() {
            return this.getStaticLabel() + " " + this.getOptionalLabel();
        }
    }
}

