/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.utilities.BrowserControl;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class AboutDialog
extends AppDialog
implements ActionListener {
    private JButton btnClose;
    private JLabel splash = new JLabel();
    private JLabel info = new JLabel();

    public AboutDialog(Frame frame) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(AppPrefs.getLabel("dialog.about.title", "WordRider 0.55"));
        this.setDefaultCloseOperation(2);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AboutDialog.this.playSound();
            }
        });
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.cancel();
    }

    private void init() throws Exception {
        this.setResizable(false);
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        container.setLayout(new BorderLayout());
        container.add((Component)this.splash, "Center");
        ImageIcon imageIcon = Swinger.getIcon("splash.gif");
        this.splash.setIcon(imageIcon);
        if (imageIcon != null) {
            this.splash.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        }
        this.splash.setLayout(new BoxLayout(this.splash, 1));
        this.info.setBorder(new EmptyBorder(87, 25, 0, 0));
        this.info.setText(AppPrefs.getLabel("dialog.about.text"));
        JLabel jLabel = new JLabel(AppPrefs.getLabel("dialog.about.weblink", "http://wordrider.net"));
        JLabel jLabel2 = new JLabel(AppPrefs.getLabel("dialog.about.maillink", "info@wordrider.net"));
        EmptyBorder emptyBorder = new EmptyBorder(0, 25, 0, 0);
        jLabel.setSize(50, 20);
        jLabel2.setSize(50, 20);
        jLabel.setBorder(emptyBorder);
        jLabel2.setBorder(emptyBorder);
        jLabel.addMouseListener(new URLMouseClickAdapter("http://wordrider.net"));
        jLabel2.addMouseListener(new URLMouseClickAdapter("mailto:info@wordrider.net"));
        this.splash.add(this.info);
        this.splash.add(jLabel);
        this.splash.add(jLabel2);
        this.splash.setBorder(new LineBorder(Color.BLACK, 2, true));
        container.add((Component)jPanel, "South");
        jPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(80, 25);
        this.btnClose = Swinger.getRiderButton("dialog.about.btnClose");
        this.btnClose.addActionListener(this);
        this.btnClose.setMinimumSize(dimension);
        this.btnClose.setPreferredSize(dimension);
        this.btnClose.setMaximumSize(dimension);
        jPanel.add((Component)this.btnClose, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(4, 23, 4, 5), 0, 0));
        this.pack();
    }

    private void playSound() {
        URL uRL = ((URLClassLoader)AboutDialog.class.getClassLoader()).findResource("resources/sound/sound.wav");
        if (uRL != null) {
            AudioClip audioClip = Applet.newAudioClip(uRL);
            if (audioClip != null) {
                audioClip.play();
            }
            audioClip = null;
        }
    }

    private class URLMouseClickAdapter
    extends MouseAdapter {
        private String url = "";

        public URLMouseClickAdapter(String string) {
            this.url = string;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            BrowserControl.showURL(this.url);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getDefaultCursor());
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            ((Component)mouseEvent.getSource()).setCursor(Cursor.getPredefinedCursor(12));
        }
    }
}

