/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import net.wordrider.core.managers.FileInstance;

class CheckRenderer
extends JPanel
implements ListCellRenderer {
    protected final JCheckBox check;
    protected final ListLabel label;
    protected final Icon commonIcon;
    protected static Border noFocusBorder;

    public CheckRenderer() {
        this.setLayout(null);
        this.check = new JCheckBox();
        this.add(this.check);
        this.label = new ListLabel();
        this.add(this.label);
        this.check.setBackground(null);
        if (noFocusBorder == null) {
            noFocusBorder = new EmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(noFocusBorder);
        this.check.setBorder(noFocusBorder);
        this.commonIcon = UIManager.getIcon("Tree.leafIcon");
    }

    public final Dimension getPreferredSize() {
        Dimension dimension = this.check.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        return new Dimension(dimension.width + dimension2.width, dimension.height < dimension2.height ? dimension2.height : dimension.height);
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        this.setComponentOrientation(jList.getComponentOrientation());
        if (bl) {
            this.setBackground(jList.getSelectionBackground());
            this.setForeground(jList.getSelectionForeground());
        } else {
            this.setBackground(jList.getBackground());
            this.setForeground(jList.getForeground());
        }
        this.setEnabled(jList.isEnabled());
        this.label.setFont(jList.getFont());
        this.label.setText(object.toString());
        Icon icon = ((FileInstance)object).getIcon();
        if (icon == null) {
            icon = this.commonIcon;
        }
        this.label.setIcon(icon);
        this.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : noFocusBorder);
        return this;
    }

    public final void doLayout() {
        Dimension dimension = this.check.getPreferredSize();
        Dimension dimension2 = this.label.getPreferredSize();
        int n = 0;
        int n2 = 0;
        if (dimension.height < dimension2.height) {
            n = (dimension2.height - dimension.height) / 2;
        } else {
            n2 = (dimension.height - dimension2.height) / 2;
        }
        this.check.setLocation(4, n);
        this.check.setBounds(4, n, dimension.width, dimension.height);
        this.label.setLocation(dimension.width + 4, n2);
        this.label.setBounds(dimension.width + 4, n2, dimension2.width, dimension2.height);
    }

    public final class ListLabel
    extends JLabel {
        public final Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension = new Dimension(dimension.width + 10, dimension.height);
            }
            return dimension;
        }
    }
}

