/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.CheckRenderer;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class CloseDialog
extends AppDialog {
    private JButton btnCancel;
    private JButton btnSave;
    private JButton selectAll;
    private JButton diselectAll;
    private JList list;
    private static final int RESULT_SAVE = 0;
    private static final int RESULT_CANCEL = 1;
    private int result = 1;
    private ArrayList listData;
    private boolean[] listDataChecked;

    public CloseDialog(Frame frame, Collection collection) {
        super(frame, true);
        try {
            this.init();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
        this.prepareData(collection);
        this.initDialogContents();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(AppPrefs.getLabel("dialog.close.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private void prepareData(Collection collection) {
        TreeSet treeSet = new TreeSet(collection);
        int n = treeSet.size();
        this.listDataChecked = new boolean[n];
        this.checkAll(true);
        this.listData = new ArrayList(treeSet);
    }

    private void initDialogContents() {
        this.list.setModel(new AbstractListModel(){

            public int getSize() {
                return CloseDialog.this.listData.size();
            }

            public Object getElementAt(int n) {
                return CloseDialog.this.listData.get(n);
            }
        });
    }

    private void btnCancel_actionPerformed() {
        this.cancel();
    }

    private void btnSave_actionPerformed() {
        this.result = 0;
        this.cancel();
    }

    public final Collection getReturnList() {
        if (this.result == 1) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        int n = this.listData.size();
        for (int i = 0; i < n; ++i) {
            if (!this.listDataChecked[i]) continue;
            arrayList.add(this.listData.get(i));
        }
        return arrayList;
    }

    private void checkAll(boolean bl) {
        int n = this.listDataChecked.length;
        for (int i = 0; i < n; ++i) {
            this.listDataChecked[i] = bl;
        }
    }

    private void toggleChecked(int n) {
        this.listDataChecked[n] = !this.listDataChecked[n];
        Rectangle rectangle = this.list.getCellBounds(n, n);
        this.list.repaint(rectangle);
    }

    private void init() throws Exception {
        Container container = this.getContentPane();
        JPanel jPanel = new JPanel();
        container.setLayout(new BorderLayout());
        this.list = new JList();
        JScrollPane jScrollPane = new JScrollPane(this.list);
        container.add((Component)jScrollPane, "Center");
        this.list.addKeyListener(new MyKeyAdapter());
        this.list.setCellRenderer(new CheckListRenderer());
        this.list.setSelectionMode(0);
        jScrollPane.setPreferredSize(new Dimension(220, 150));
        this.list.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.list.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                CloseDialog.this.toggleChecked(CloseDialog.this.list.locationToIndex(mouseEvent.getPoint()));
            }
        });
        container.add((Component)jPanel, "South");
        jPanel.setLayout(new GridBagLayout());
        Dimension dimension = new Dimension(80, 25);
        SelectAction selectAction = new SelectAction();
        this.selectAll = Swinger.getRiderButton("dialog.close.btnSelectAll");
        this.selectAll.addActionListener(selectAction);
        this.diselectAll = Swinger.getRiderButton("dialog.close.btnNone");
        this.diselectAll.addActionListener(selectAction);
        this.btnCancel = Swinger.getRiderButton("dialog.close.btnCancel");
        this.btnCancel.setMinimumSize(dimension);
        this.btnCancel.setPreferredSize(dimension);
        this.btnCancel.setMaximumSize(dimension);
        this.btnSave = Swinger.getRiderButton("dialog.close.btnOK");
        this.btnSave.setMinimumSize(dimension);
        this.btnSave.setPreferredSize(dimension);
        this.btnSave.setMaximumSize(dimension);
        ActionButtonsAdapter actionButtonsAdapter = new ActionButtonsAdapter();
        this.btnSave.addActionListener(actionButtonsAdapter);
        this.btnCancel.addActionListener(actionButtonsAdapter);
        jPanel.add((Component)this.selectAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 4, 4, 5), 0, 0));
        jPanel.add((Component)this.diselectAll, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 8, 4, 5), 0, 0));
        jPanel.add((Component)this.btnSave, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 23, 4, 5), 0, 0));
        jPanel.add((Component)this.btnCancel, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(4, 8, 4, 5), 0, 0));
        this.setSize(350, 195);
        this.pack();
    }

    private class SelectAction
    implements ActionListener {
        private SelectAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CloseDialog.this.checkAll(actionEvent.getSource().equals(CloseDialog.this.selectAll));
            CloseDialog.this.list.repaint();
        }
    }

    private class MyKeyAdapter
    extends KeyAdapter {
        private MyKeyAdapter() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
                CloseDialog.this.toggleChecked(CloseDialog.this.list.getSelectedIndex());
            }
        }
    }

    private class CheckListRenderer
    extends CheckRenderer {
        private CheckListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.check.setSelected(CloseDialog.this.listDataChecked[n]);
            return super.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }

    private class ActionButtonsAdapter
    implements ActionListener {
        private ActionButtonsAdapter() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(CloseDialog.this.btnSave)) {
                CloseDialog.this.btnSave_actionPerformed();
            } else {
                CloseDialog.this.btnCancel_actionPerformed();
            }
        }
    }
}

