/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import net.wordrider.ti89.TIImageDecoder;
import net.wordrider.utilities.Utils;

final class ImagePreview
extends JComponent
implements PropertyChangeListener {
    private ImageIcon thumbnail = null;
    private File file = null;

    public ImagePreview(JFileChooser jFileChooser) {
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    private static final Image loadPicture(File file) {
        TIImageDecoder tIImageDecoder = new TIImageDecoder();
        try {
            if (!tIImageDecoder.openFromFile(file)) {
                Utils.log(2, "Image was loaded but the file might be corrupted (invalid checksum)");
            }
            return Toolkit.getDefaultToolkit().createImage(tIImageDecoder);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadImage() {
        if (this.file == null) {
            this.thumbnail = null;
            return;
        }
        Image image = ImagePreview.loadPicture(this.file);
        if (image != null) {
            this.thumbnail = image.getWidth(this) > 90 ? new ImageIcon(image.getScaledInstance(90, -1, 1)) : new ImageIcon(image);
        }
    }

    public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            this.file = (File)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (bl) {
            this.thumbnail = null;
            if (this.isShowing()) {
                this.loadImage();
                this.repaint();
            }
        }
    }

    protected final void paintComponent(Graphics graphics) {
        if (this.thumbnail == null) {
            this.loadImage();
        }
        if (this.thumbnail != null) {
            int n = this.getWidth() / 2 - this.thumbnail.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.thumbnail.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.thumbnail.paintIcon(this, graphics, n, n2);
        }
    }
}

