/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import net.wordrider.core.AppPrefs;
import net.wordrider.dialogs.ImageFileView;
import net.wordrider.dialogs.ImagePreview;
import net.wordrider.utilities.Utils;

public class PictureDialog
extends JFileChooser {
    public PictureDialog() {
        this.init();
    }

    public PictureDialog(File file) {
        super(file);
        this.init();
    }

    public int showInsertDialog(Component component) {
        return super.showDialog(component, AppPrefs.getLabel("picturedialog.insertBtn"));
    }

    private void init() {
        this.setAcceptAllFileFilterUsed(false);
        this.setDialogTitle(AppPrefs.getLabel("picturedialog.title"));
        this.setFileFilter(new MyFileFilter());
        this.setFileView(new ImageFileView());
        this.setAccessory(new ImagePreview(this));
    }

    private static final class MyFileFilter
    extends FileFilter {
        private MyFileFilter() {
        }

        public final String getDescription() {
            return AppPrefs.getLabel("picturedialog.ti89files");
        }

        public final boolean accept(File file) {
            if (file.isFile()) {
                String string = Utils.getExtension(file);
                return string != null ? string.equals("89i") : true;
            }
            return true;
        }
    }
}

