/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.gui;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.gui.WordRiderMetalTheme;
import net.wordrider.utilities.Utils;

public class LookAndFeels {
    private static final String KUNSTSTOFF = "com.incors.plaf.kunststoff.KunststoffLookAndFeel";
    private static final String lookAndFieldSelectedKey = "lookAndFeel";
    private static final String themeSelectedKey = "theme";
    private static String selectedLookAndFeel = AppPrefs.getProperty("lookAndFeel", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
    private static String selectedTheme = AppPrefs.getProperty("theme", null);
    private static final ClassLoader classLoader = LookAndFeels.initClassLoader();

    private static ClassLoader initClassLoader() {
        String string = AppPrefs.getAppPath() + "lib";
        Utils.log(0, "Loading plugin path " + string);
        File file = new File(string);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            if (file.exists()) {
                File[] fileArray = file.listFiles(new FilenameFilter(){

                    public boolean accept(File file, String string) {
                        return string.endsWith(".jar");
                    }
                });
                int n = fileArray.length;
                URL[] uRLArray = new URL[n];
                boolean bl = Utils.isDefinedForLog(0);
                for (int i = 0; i < n; ++i) {
                    uRLArray[i] = fileArray[i].toURL();
                    if (!bl) continue;
                    Utils.logDebug("Loading URL with jar " + uRLArray[i]);
                }
                classLoader = new URLClassLoader(uRLArray, classLoader);
            }
            return classLoader;
        }
        catch (Exception exception) {
            Utils.processException(exception);
            return classLoader;
        }
    }

    public static final boolean isSelectedLaF(String string, String string2) {
        if (string.equals(selectedLookAndFeel)) {
            if (selectedTheme != null) {
                return selectedTheme.equals(string2);
            }
            return string2 == null;
        }
        return false;
    }

    public static final void storeSelectedLaF(String string, String string2) {
        selectedLookAndFeel = string;
        AppPrefs.storeProperty(lookAndFieldSelectedKey, selectedLookAndFeel);
        if (string2 == null) {
            selectedTheme = null;
            AppPrefs.removeProperty(themeSelectedKey);
        } else {
            selectedTheme = string2;
            AppPrefs.storeProperty(themeSelectedKey, selectedTheme);
        }
    }

    public static final void loadLookAndFeelSettings() {
        LookAndFeels.loadLookAndFeel(selectedLookAndFeel, selectedTheme, false);
    }

    public static final Class isPresent(String string) {
        try {
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (Utils.isDefinedForLog(0)) {
                Utils.logDebug("Possible problem.Look and feel class/theme " + string + " was not detected(not in /lib?).Check " + "resources/lookandfeels/lookandfeels.properties");
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean loadLookAndFeel(String string, String string2, boolean bl) {
        try {
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                if (string.equals(KUNSTSTOFF)) {
                    LookAndFeels.initKunststoff();
                }
                LookAndFeels.initLaf(string, string2);
            }
            catch (Exception exception) {
                Utils.log(3, string + " was not found.");
                if (Utils.isDefinedForLog(0)) {
                    Utils.processException(exception);
                }
                if (!string.equals(KUNSTSTOFF)) {
                    try {
                        LookAndFeels.initKunststoff();
                        LookAndFeels.initKunststoff();
                    }
                    catch (Exception exception2) {
                        Utils.log(3, "Kunststoff Look and Feel was not found. Using a default metal theme.");
                        boolean bl3 = false;
                        Object var7_4 = null;
                        if (!bl) return bl3;
                        SwingUtilities.updateComponentTreeUI(MainApp.getInstance().getMainAppFrame());
                        UIManager.getLookAndFeel().getDefaults();
                        MainApp.getInstance().getMainAppFrame().invalidate();
                        MainApp.getInstance().getMainAppFrame().validate();
                        MainApp.getInstance().getMainAppFrame().repaint();
                        return bl3;
                    }
                }
                boolean bl2 = false;
                Object var7_5 = null;
                if (!bl) return bl2;
                SwingUtilities.updateComponentTreeUI(MainApp.getInstance().getMainAppFrame());
                UIManager.getLookAndFeel().getDefaults();
                MainApp.getInstance().getMainAppFrame().invalidate();
                MainApp.getInstance().getMainAppFrame().validate();
                MainApp.getInstance().getMainAppFrame().repaint();
                return bl2;
            }
            Object var7_3 = null;
            if (!bl) return true;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!bl) throw throwable;
            SwingUtilities.updateComponentTreeUI(MainApp.getInstance().getMainAppFrame());
            UIManager.getLookAndFeel().getDefaults();
            MainApp.getInstance().getMainAppFrame().invalidate();
            MainApp.getInstance().getMainAppFrame().validate();
            MainApp.getInstance().getMainAppFrame().repaint();
            throw throwable;
        }
        SwingUtilities.updateComponentTreeUI(MainApp.getInstance().getMainAppFrame());
        UIManager.getLookAndFeel().getDefaults();
        MainApp.getInstance().getMainAppFrame().invalidate();
        MainApp.getInstance().getMainAppFrame().validate();
        MainApp.getInstance().getMainAppFrame().repaint();
        return true;
    }

    private static void initKunststoff() throws Exception {
        LookAndFeels.initLafWithTheme(KUNSTSTOFF, new WordRiderMetalTheme());
    }

    private static void initLafWithTheme(String string, MetalTheme metalTheme) throws Exception {
        LookAndFeel lookAndFeel = (LookAndFeel)classLoader.loadClass(string).newInstance();
        if (metalTheme != null && lookAndFeel instanceof MetalLookAndFeel) {
            lookAndFeel.getClass().getMethod("setCurrentTheme", MetalTheme.class).invoke((Object)lookAndFeel, metalTheme);
        }
        UIManager.put("ClassLoader", classLoader);
        UIManager.setLookAndFeel(lookAndFeel);
        UIManager.put("ClassLoader", classLoader);
    }

    private static void initLaf(String string, String string2) throws Exception {
        if (string2 != null) {
            Class clazz = LookAndFeels.isPresent(string2);
            if (clazz != null) {
                Object t = clazz.newInstance();
                if (t instanceof MetalTheme) {
                    LookAndFeels.initLafWithTheme(string, (MetalTheme)t);
                } else {
                    Utils.log(2, "Theme " + t.getClass().getName() + " cannot be set.Theme is not an instance of Metaltheme");
                    LookAndFeels.initLafWithTheme(string, null);
                }
            }
        } else {
            LookAndFeels.initLafWithTheme(string, null);
        }
    }

    static {
        if (selectedTheme == null && selectedLookAndFeel.equals(KUNSTSTOFF)) {
            selectedTheme = WordRiderMetalTheme.class.getName();
        }
    }
}

