/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.plugintools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.PluginTool;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

public final class CharacterList
extends PluginTool
implements MouseMotionListener,
MouseListener,
ItemListener {
    private static final int zoomWindowWidth = 36;
    private JTable charsTable;
    private JTable lastUsedCharsTable;
    private JTextPane editor = null;
    private JComboBox charsTypeCombo;
    private static Cursor blankCursor;
    private static boolean nowZooming;
    private boolean firstTime = true;
    private JWindow zoomWindow;
    private BufferedImage zoomImage = null;
    private Character activeCharacter;

    public CharacterList() {
        try {
            this.setFileInstance(null);
            this.init();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
    }

    public final String getName() {
        return AppPrefs.getLabel("characters.title");
    }

    public String getTabName() {
        return this.getName();
    }

    public final Icon getIcon() {
        return Swinger.getIcon("char.gif");
    }

    public final String getTip() {
        return AppPrefs.getLabel("characters.tooltip");
    }

    public final void activate() {
        this.setFileInstance(MainApp.getInstance().getMainAppFrame().getManagerDirector().getAreaManager().getActiveFileInstance());
        Utils.log(0, "CharsList activated");
    }

    public final void deactivate() {
        this.setFileInstance(null);
        Utils.log(0, "CharsList deactivated");
    }

    private void setEditor(JTextComponent jTextComponent) {
        this.editor = (JTextPane)jTextComponent;
        this.setEnabled(this.editor != null);
    }

    public void setFileInstance(IFileInstance iFileInstance) {
        if (iFileInstance != null) {
            this.setEditor(iFileInstance.getTextComponent());
        } else {
            this.setEditor(null);
        }
        this.setEnabled(this.editor != null);
    }

    private CharsTableModel getCharsTableModel() {
        return (CharsTableModel)this.charsTable.getModel();
    }

    private void initTable(JTable jTable, KeyListener keyListener, TableCellRenderer tableCellRenderer) {
        jTable.setDefaultRenderer(Object.class, tableCellRenderer);
        jTable.setSelectionMode(0);
        jTable.setColumnSelectionAllowed(false);
        jTable.setRowSelectionAllowed(false);
        jTable.setTableHeader(null);
        jTable.addMouseMotionListener(this);
        jTable.setFont(RiderStyles.getAreaFont().deriveFont(0, 13.0f));
        jTable.addMouseListener(this);
        jTable.setRowHeight(25);
        jTable.addKeyListener(keyListener);
        jTable.setFocusCycleRoot(true);
    }

    private final void init() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        byte[] byArray = new byte[]{0};
        blankCursor = toolkit.createCustomCursor(toolkit.createImage(byArray), new Point(0, 0), "");
        this.zoomWindow = new JWindow(MainApp.getInstance().getMainAppFrame()){

            public void paint(Graphics graphics) {
                graphics.drawImage(CharacterList.this.zoomImage, 0, 0, CharacterList.this.zoomWindow);
            }
        };
        this.zoomWindow.setCursor(blankCursor);
        this.zoomWindow.pack();
        CellRenderer cellRenderer = new CellRenderer();
        AddCharByKeyListener addCharByKeyListener = new AddCharByKeyListener();
        this.charsTable = new JTable(new CharsTableModel());
        this.initTable(this.charsTable, addCharByKeyListener, cellRenderer);
        this.lastUsedCharsTable = new JTable(new LastUsedCharsTableModel());
        this.initTable(this.lastUsedCharsTable, addCharByKeyListener, cellRenderer);
        this.lastUsedCharsTable.setBorder(BorderFactory.createEtchedBorder());
        this.setLayout(new BorderLayout());
        this.charsTypeCombo = new JComboBox();
        this.charsTypeCombo.setBorder(BorderFactory.createEmptyBorder(0, 5, 4, 5));
        this.charsTypeCombo.setPreferredSize(new Dimension(170, 23));
        ArrayList arrayList = this.getCharsTableModel().getAvailableCharTables();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            this.charsTypeCombo.addItem(object.next());
        }
        this.charsTypeCombo.addItemListener(this);
        this.itemStateChanged(null);
        object = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(150, 30));
        ((Container)object).add((Component)jPanel2, "North");
        ((Container)object).add((Component)jPanel, "South");
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 4, 5, 4));
        jPanel2.add((Component)this.lastUsedCharsTable, "Center");
        jPanel2.setPreferredSize(new Dimension(150, 35));
        jPanel.add((Component)this.charsTypeCombo, "West");
        JScrollPane jScrollPane = new JScrollPane(this.charsTable);
        jScrollPane.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.add((Component)object, "North");
        this.add((Component)new JScrollPane(this.charsTable), "Center");
        this.setPreferredSize(new Dimension(180, 250));
        this.setMaximumSize(new Dimension(200, 250));
        this.setVisible(true);
    }

    private final boolean firstTime() {
        return this.firstTime;
    }

    private final void refresh() {
        this.firstTime = false;
        this.repaint();
    }

    private final void showZoomed(JTable jTable, int n, int n2, Character c) {
        if (c == null) {
            return;
        }
        this.activeCharacter = c;
        jTable.setCursor(blankCursor);
        if (!nowZooming) {
            if (this.zoomWindow.getWarningString() != null) {
                this.zoomWindow.setSize(36, 36);
            } else {
                this.zoomWindow.setSize(37, 37);
            }
        }
        this.zoomImage = (BufferedImage)this.zoomWindow.createImage(37, 37);
        Graphics2D graphics2D = (Graphics2D)this.zoomImage.getGraphics();
        Font font = RiderStyles.getAreaBigFont();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 36, 36);
        graphics2D.setColor(Color.black);
        graphics2D.drawRect(0, 0, 36, 36);
        graphics2D.setFont(font);
        FontMetrics fontMetrics = jTable.getFontMetrics(font);
        graphics2D.drawString(c.toString(), (36 - fontMetrics.charWidth(c.charValue())) / 2, (36 - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent());
        graphics2D.dispose();
        this.zoomWindow.getGraphics().drawImage(this.zoomImage, 0, 0, this);
        Rectangle rectangle = jTable.getCellRect(n, n2, false);
        Point point = jTable.getLocationOnScreen();
        int n3 = rectangle.x - (36 - rectangle.width) / 2;
        int n4 = rectangle.y - (36 - rectangle.height) / 2;
        this.zoomWindow.setLocation(point.x + n3, point.y + n4);
        if (!nowZooming) {
            this.zoomWindow.setVisible(true);
        }
        nowZooming = true;
        if (this.firstTime()) {
            this.refresh();
        }
    }

    private static final Character getSelectedCharacter(JTable jTable, int n, int n2) {
        return (Character)jTable.getModel().getValueAt(n, n2);
    }

    private static final Character getSelectedCharacter(JTable jTable) {
        return (Character)jTable.getModel().getValueAt(jTable.getSelectedRow(), jTable.getSelectedColumn());
    }

    public final void mouseDragged(MouseEvent mouseEvent) {
        int n;
        int n2;
        JTable jTable;
        Character c;
        if (nowZooming && (c = CharacterList.getSelectedCharacter(jTable = (JTable)mouseEvent.getSource(), n2 = jTable.rowAtPoint(mouseEvent.getPoint()), n = jTable.columnAtPoint(mouseEvent.getPoint()))) != null && c.compareTo(this.activeCharacter) != 0) {
            this.showZoomed(jTable, n2, n, c);
        }
    }

    public final void mouseMoved(MouseEvent mouseEvent) {
    }

    public final void mouseClicked(MouseEvent mouseEvent) {
    }

    private final JTextPane getEditor() {
        return this.editor;
    }

    public final void mouseEntered(MouseEvent mouseEvent) {
    }

    public final void mouseExited(MouseEvent mouseEvent) {
    }

    public final void mousePressed(MouseEvent mouseEvent) {
        JTable jTable = (JTable)mouseEvent.getSource();
        int n = jTable.rowAtPoint(mouseEvent.getPoint());
        int n2 = jTable.columnAtPoint(mouseEvent.getPoint());
        Character c = CharacterList.getSelectedCharacter(jTable, n, n2);
        this.showZoomed(jTable, n, n2, c);
    }

    public final void mouseReleased(MouseEvent mouseEvent) {
        if (nowZooming) {
            this.zoomWindow.setVisible(false);
        }
        nowZooming = false;
        JTable jTable = (JTable)mouseEvent.getSource();
        Character c = CharacterList.getSelectedCharacter(jTable, jTable.rowAtPoint(mouseEvent.getPoint()), jTable.columnAtPoint(mouseEvent.getPoint()));
        if (c != null) {
            this.insertCharacter(c);
            if (jTable.equals(this.charsTable)) {
                ((LastUsedCharsTableModel)this.lastUsedCharsTable.getModel()).addUsedChar(c);
            }
        }
        mouseEvent.consume();
        jTable.setCursor(Cursor.getDefaultCursor());
    }

    public final void itemStateChanged(ItemEvent itemEvent) {
        this.getCharsTableModel().selectCharTable(this.charsTypeCombo.getSelectedIndex());
    }

    private void insertCharacter(Character c) {
        if (this.editor == null) {
            return;
        }
        try {
            this.editor.select(this.editor.getCaretPosition(), this.editor.getCaretPosition());
            this.editor.getDocument().insertString(this.editor.getCaretPosition(), c.toString(), this.editor.getInputAttributes());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    CharacterList.this.getEditor().requestFocus();
                }
            });
        }
        catch (BadLocationException badLocationException) {
            Utils.processException(badLocationException);
            return;
        }
    }

    public boolean closeSoft() {
        return false;
    }

    public void closeHard() {
    }

    static {
        nowZooming = false;
    }

    private static final class LastUsedCharsTableModel
    extends AbstractTableModel {
        private static final int COLUMNS_COUNT = 8;
        private final Stack usedCharsList = new Stack();

        private LastUsedCharsTableModel() {
        }

        public final void addUsedChar(Character c) {
            if (!this.usedCharsList.contains(c)) {
                this.usedCharsList.add(0, c);
                this.usedCharsList.setSize(8);
                this.fireTableDataChanged();
            }
        }

        public final int getColumnCount() {
            return 8;
        }

        public final int getRowCount() {
            return 1;
        }

        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        public final Object getValueAt(int n, int n2) {
            return n2 >= 0 && n2 < this.usedCharsList.size() ? this.usedCharsList.get(n2) : null;
        }
    }

    private static final class CharsTableModel
    extends AbstractTableModel {
        private static final char[] GREEK_CHARS = new char[]{'\u20ac', '\u0081', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u00b1', '\u0160', '\u0152', '\u008d', '\u008f', '\u0090', '\u2018', '\u2019', '\u201c', '\u201d', '\u00b7', '\u00b6', '\u017d', '\u2039'};
        private static final char[] MATH_SYMBOLS1 = new char[]{'\u00bb', '\u02dc', '\u2014', '\u00b4', '\u00b8', '\u00a2', '\u203a', '\u00bd', '\u00d7', '\u00f7', '\u00a7', '\u00a9', '\u00ac', '\u00b0', '\u00be', '\u00bc', '\u00b3', '\u0153', '\u0161', '\u00de', '\u00af', '\u00bf', '\u0178', '\u017e', '{', '\u00aa'};
        private static final char[] MATH_SYMBOLS2 = new char[]{'\u00c6', '\u00b8', '|', '\"', ';', ':', '\u02c6', '\\', '\u2013', '<', '>', '{', '}', '[', ']', '(', ')', ',', '^', '\u0152'};
        private static final char[] SPECIAL_SYMBOLS = new char[]{'!', '\"', '#', '$', '%', '&', '\'', '?', '@', '_', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a8', '\u00ac', '\u00b9', '\u00d7', '\u00de'};
        private static final int columnsCount = 5;
        private int dataLength = 0;
        private char[] charArray;

        private CharsTableModel() {
        }

        public final int getColumnCount() {
            return 5;
        }

        public final int getRowCount() {
            return this.dataLength / 5 + (this.dataLength % 5 != 0 ? 1 : 0);
        }

        public final boolean isCellEditable(int n, int n2) {
            return false;
        }

        public final Object getValueAt(int n, int n2) {
            return (n = n * 5 + n2) < this.dataLength && n >= 0 ? new Character(this.charArray[n]) : null;
        }

        public final ArrayList getAvailableCharTables() {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            arrayList.add(AppPrefs.getLabel("characters.list.greek"));
            arrayList.add(AppPrefs.getLabel("characters.list.math1"));
            arrayList.add(AppPrefs.getLabel("characters.list.math2"));
            arrayList.add(AppPrefs.getLabel("characters.list.specialSyms"));
            arrayList.add(AppPrefs.getLabel("characters.list.allChars"));
            return arrayList;
        }

        private final void setCharArray(char[] cArray) {
            this.charArray = cArray;
            this.dataLength = cArray.length;
            this.fireTableDataChanged();
        }

        public final void selectCharTable(int n) {
            switch (n) {
                case 0: {
                    this.setCharArray(GREEK_CHARS);
                    break;
                }
                case 1: {
                    this.setCharArray(MATH_SYMBOLS1);
                    break;
                }
                case 2: {
                    this.setCharArray(MATH_SYMBOLS2);
                    break;
                }
                case 3: {
                    this.setCharArray(SPECIAL_SYMBOLS);
                    break;
                }
                default: {
                    this.setCharArray(RiderEditorKit.TI92PC_UNICODE_FONT);
                }
            }
        }
    }

    private final class AddCharByKeyListener
    implements KeyListener {
        private AddCharByKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 10) {
                JTable jTable = (JTable)keyEvent.getSource();
                Character c = CharacterList.getSelectedCharacter(jTable);
                if (c != null) {
                    CharacterList.this.insertCharacter(c);
                    if (jTable.equals(CharacterList.this.charsTable)) {
                        ((LastUsedCharsTableModel)CharacterList.this.lastUsedCharsTable.getModel()).addUsedChar(c);
                    }
                }
                keyEvent.consume();
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    private static final class CellRenderer
    extends DefaultTableCellRenderer {
        private static final boolean isWindows = AppPrefs.isWindows();

        public CellRenderer() {
            this.setHorizontalAlignment(0);
            this.setHorizontalTextPosition(0);
        }

        public final Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                char c = ((Character)object).charValue();
                String string = c < '\u00ff' && isWindows ? "alt-0" + c + "  " : "";
                this.setToolTipText(string + AppPrefs.getLabel("characters.unicode", Integer.toHexString(c)));
            }
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }
}

