/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.ti89;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import net.wordrider.ti89.InvalidDataTypeException;
import net.wordrider.ti89.NotSupportedFileException;
import net.wordrider.ti89.TIFile;
import net.wordrider.utilities.Utils;

public abstract class TIFileReader
extends TIFile {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean openFromFile(File file) throws InvalidDataTypeException, NotSupportedFileException, IOException {
        FilterInputStream filterInputStream = null;
        try {
            if (!file.exists() && !file.createNewFile()) {
                boolean bl = false;
                return bl;
            }
            filterInputStream = new DataInputStream(new FileInputStream(file));
            this.readHeader((DataInputStream)filterInputStream);
            this.readContent((DataInputStream)filterInputStream);
            char c = TIFileReader.readChecksum((DataInputStream)filterInputStream);
            char c2 = this.getCheckSum();
            if (c != c2) {
                Utils.log(2, "File '" + file.getPath() + "' was loaded but the file might be corrupted (CRC mismatch)");
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (filterInputStream != null) {
                filterInputStream.close();
            }
        }
    }

    private static String getString(byte[] byArray) {
        int n;
        int n2 = byArray.length;
        for (n = 0; n < n2 && byArray[n] != 0; ++n) {
        }
        try {
            return new String(byArray, 0, n, "ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Utils.processException(unsupportedEncodingException);
            return "unknown";
        }
    }

    private void readHeader(DataInputStream dataInputStream) throws NotSupportedFileException, InvalidDataTypeException, IOException {
        byte[] byArray = new byte[8];
        dataInputStream.readFully(byArray);
        String string = TIFileReader.getString(byArray);
        if (!this.isSupportedHeader(string)) {
            throw new NotSupportedFileException(string);
        }
        dataInputStream.skip(2L);
        dataInputStream.readFully(byArray);
        this.fileInfo.setFolderName(TIFileReader.getString(byArray));
        byArray = new byte[40];
        dataInputStream.readFully(byArray);
        this.fileInfo.setComment(TIFileReader.getString(byArray));
        dataInputStream.readShort();
        dataInputStream.skip(4L);
        byArray = new byte[8];
        dataInputStream.readFully(byArray);
        this.fileInfo.setVarName(TIFileReader.getString(byArray));
        if (dataInputStream.readUnsignedByte() != this.getDataType()) {
            throw new InvalidDataTypeException();
        }
        dataInputStream.skipBytes(1);
        dataInputStream.skipBytes(6);
        dataInputStream.readUnsignedByte();
        dataInputStream.readUnsignedByte();
        dataInputStream.skip(4L);
    }

    private static char readChecksum(DataInputStream dataInputStream) throws IOException {
        return (char)(dataInputStream.readUnsignedByte() + (dataInputStream.readUnsignedByte() << 8));
    }

    protected abstract void readContent(DataInputStream var1) throws IOException;

    protected abstract boolean isSupportedHeader(String var1);
}

