/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.ti89;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.IndexColorModel;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import net.wordrider.ti89.TIFileReader;
import net.wordrider.utilities.Utils;

public final class TIImageDecoder
extends TIFileReader
implements ImageProducer {
    private static final Object TI_ORIGFILENAME = "TI_ORIGFILENAME";
    private static final Object TI_ORIGFILEDIR = "TI_ORIGFILEDIR";
    private static final Object TI_IMAGEPATH = "TI_IMAGEPATH";
    private ImageConsumer consumer;
    private final boolean loadError = false;
    private int width = -1;
    private int height = -1;
    private byte[] store;
    private final Hashtable props = new Hashtable(10);
    private static final String[] supportedFormats = new String[]{"**TI92P*", "**TI89**"};
    private char sum;
    private static final int hints = 30;

    public final String getOriginalFileDir() {
        return (String)this.props.get(TI_ORIGFILEDIR);
    }

    public final String getOriginalFileName() {
        return (String)this.props.get(TI_ORIGFILENAME);
    }

    public final void setOriginalFileName(String string) {
        this.props.put(TI_ORIGFILENAME, string);
    }

    public final void setOriginalFileDir(String string) {
        this.props.put(TI_ORIGFILEDIR, string);
    }

    public final void setImagePath(String string) {
        this.props.put(TI_IMAGEPATH, string);
    }

    public final String getStringRepresentation() {
        return "&P" + this.getOriginalFileName();
    }

    public final String getImagePath() {
        return (String)this.props.get(TI_IMAGEPATH);
    }

    protected final void readContent(DataInputStream dataInputStream) throws IOException {
        this.sum = (char)(dataInputStream.readUnsignedByte() + dataInputStream.readUnsignedByte());
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        this.height = (n << 8) + n2;
        this.sum = (char)(this.sum + (n + n2));
        n = dataInputStream.readUnsignedByte();
        n2 = dataInputStream.readUnsignedByte();
        this.width = (n << 8) + n2;
        this.sum = (char)(this.sum + (n + n2));
        if (this.width % 8 != 0) {
            this.width += 8 - this.width % 8;
        }
        int n3 = this.width / 8;
        byte[] byArray = new byte[this.height * n3];
        dataInputStream.readFully(byArray);
        int n4 = byArray.length;
        this.store = new byte[n4 * 8];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            byte by = byArray[i];
            this.sum = (char)(this.sum + (char)(by & 0xFF));
            for (int j = 7; j >= 0; --j) {
                int n6 = by & 1 << j;
                this.store[n5++] = n6 != 0 ? -1 : 0;
            }
        }
        this.sum = (char)(this.sum + dataInputStream.readUnsignedByte());
    }

    protected final boolean isSupportedHeader(String string) {
        int n = supportedFormats.length;
        for (int i = 0; i < n; ++i) {
            if (!supportedFormats[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public final int getDataType() {
        return DATA_TYPES[1];
    }

    public final String getFileHeaderType() {
        return supportedFormats[0];
    }

    public final char getCheckSum() {
        return this.sum;
    }

    public final synchronized void addConsumer(ImageConsumer imageConsumer) {
        block2: {
            this.consumer = imageConsumer;
            try {
                this.produce();
            }
            catch (Exception exception) {
                Utils.processException(exception);
                if (this.consumer == null) break block2;
                this.consumer.imageComplete(1);
            }
        }
        this.consumer = null;
    }

    public final synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        return imageConsumer == this.consumer;
    }

    public final synchronized void removeConsumer(ImageConsumer imageConsumer) {
        if (this.consumer == imageConsumer) {
            this.consumer = null;
        }
    }

    public final void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
    }

    public final void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    private void produce() {
        byte[] byArray = new byte[]{-1, 0};
        IndexColorModel indexColorModel = new IndexColorModel(1, 2, byArray, byArray, byArray);
        if (this.consumer != null) {
            this.consumer.setDimensions(this.width, this.height);
            this.consumer.setColorModel(indexColorModel);
            this.consumer.setHints(30);
            int n = 0;
            for (int i = 0; i < this.height; ++i) {
                this.consumer.setPixels(0, i, this.width, 1, (ColorModel)indexColorModel, this.store, n, this.width);
                n += this.width;
            }
            this.consumer.setProperties(this.props);
            this.consumer.imageComplete(3);
        }
    }
}

