/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.ti89;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.HashMap;
import net.wordrider.ti89.TIFileWriter;

public final class TITextFileWriter
extends TIFileWriter {
    private static final String fileHeader = "**TI92P*";
    private String textContent = "";
    private static final HashMap UNICODE2TI;
    private static int sum;

    public final String getTextContent() {
        return this.textContent;
    }

    public final void setTextContent(String string) {
        this.textContent = string == null ? "" : string;
    }

    protected final char getCheckSum() {
        return (char)(sum + 224 + 1);
    }

    protected final int getDataType() {
        return DATA_TYPES[0];
    }

    protected final String getFileHeaderType() {
        return fileHeader;
    }

    protected final void writeContent(DataOutputStream dataOutputStream) throws IOException {
        char[] cArray = this.textContent.toCharArray();
        int n = cArray.length;
        int n2 = n + 4;
        int n3 = dataOutputStream.size() + 18 + n;
        dataOutputStream.writeByte(n3 & 0xFF);
        dataOutputStream.writeByte(n3 >> 8 & 0xFF);
        dataOutputStream.writeByte(n3 >> 24 & 0xFF);
        dataOutputStream.writeByte(n3 >> 16 & 0xFF);
        dataOutputStream.writeShort(42330);
        dataOutputStream.writeShort(0);
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeByte(0);
        dataOutputStream.writeByte(1);
        sum = (n2 & 0xFF) + (n2 >> 8 & 0xFF);
        for (int i = 0; i < n; ++i) {
            int n4 = cArray[i];
            if (n4 >= 128) {
                Character c = (Character)UNICODE2TI.get(new Character((char)n4));
                if (c != null) {
                    n4 = c.charValue();
                }
            } else if (n4 == 10) {
                n4 = 13;
            }
            sum += n4;
            dataOutputStream.writeByte(n4);
        }
        dataOutputStream.writeShort(224);
    }

    static {
        sum = 0;
        UNICODE2TI = new HashMap(134);
        UNICODE2TI.put(new Character('\u00d0'), new Character('\u0012'));
        UNICODE2TI.put(new Character('\u00bb'), new Character('\u0016'));
        UNICODE2TI.put(new Character('\u00bc'), new Character('\u001c'));
        UNICODE2TI.put(new Character('\u00bd'), new Character('\u001d'));
        UNICODE2TI.put(new Character('\u00be'), new Character('\u001e'));
        UNICODE2TI.put(new Character('\u00bf'), new Character('\u001f'));
        UNICODE2TI.put(new Character('\u20ac'), new Character('\u0080'));
        UNICODE2TI.put(new Character('\u0081'), new Character('\u0081'));
        UNICODE2TI.put(new Character('\u201a'), new Character('\u0082'));
        UNICODE2TI.put(new Character('\u0192'), new Character('\u0083'));
        UNICODE2TI.put(new Character('\u201e'), new Character('\u0084'));
        UNICODE2TI.put(new Character('\u2026'), new Character('\u0085'));
        UNICODE2TI.put(new Character('\u2020'), new Character('\u0086'));
        UNICODE2TI.put(new Character('\u2021'), new Character('\u0087'));
        UNICODE2TI.put(new Character('\u02c6'), new Character('\u0088'));
        UNICODE2TI.put(new Character('\u2030'), new Character('\u0089'));
        UNICODE2TI.put(new Character('\u0160'), new Character('\u008a'));
        UNICODE2TI.put(new Character('\u2039'), new Character('\u008b'));
        UNICODE2TI.put(new Character('\u0152'), new Character('\u008c'));
        UNICODE2TI.put(new Character('\u008d'), new Character('\u008d'));
        UNICODE2TI.put(new Character('\u017d'), new Character('\u008e'));
        UNICODE2TI.put(new Character('\u008f'), new Character('\u008f'));
        UNICODE2TI.put(new Character('\u0090'), new Character('\u0090'));
        UNICODE2TI.put(new Character('\u2018'), new Character('\u0091'));
        UNICODE2TI.put(new Character('\u2019'), new Character('\u0092'));
        UNICODE2TI.put(new Character('\u0081'), new Character('\u0081'));
        UNICODE2TI.put(new Character('\u201d'), new Character('\u0094'));
        UNICODE2TI.put(new Character('\u2013'), new Character('\u0095'));
        UNICODE2TI.put(new Character('\u2014'), new Character('\u0096'));
        UNICODE2TI.put(new Character('\u00c6'), new Character('\u0097'));
        UNICODE2TI.put(new Character('\u02dc'), new Character('\u0098'));
        UNICODE2TI.put(new Character('\u2122'), new Character('\u0099'));
        UNICODE2TI.put(new Character('\u0161'), new Character('\u009a'));
        UNICODE2TI.put(new Character('\u203a'), new Character('\u009b'));
        UNICODE2TI.put(new Character('\u0153'), new Character('\u009c'));
        UNICODE2TI.put(new Character('\u009d'), new Character('\u009d'));
        UNICODE2TI.put(new Character('\u017e'), new Character('\u009e'));
        UNICODE2TI.put(new Character('\u0178'), new Character('\u009f'));
        UNICODE2TI.put(new Character('\u00a1'), new Character('\u00a0'));
        UNICODE2TI.put(new Character('\u00a2'), new Character('\u00a1'));
        UNICODE2TI.put(new Character('\u00a3'), new Character('\u00a2'));
        UNICODE2TI.put(new Character('\u00a4'), new Character('\u00a3'));
        UNICODE2TI.put(new Character('\u00a5'), new Character('\u00a4'));
        UNICODE2TI.put(new Character('\u00a6'), new Character('\u00a5'));
        UNICODE2TI.put(new Character('|'), new Character('\u00a6'));
        UNICODE2TI.put(new Character('\u00a7'), new Character('\u00a7'));
        UNICODE2TI.put(new Character('\u00a7'), new Character('\u00a8'));
        UNICODE2TI.put(new Character('\u00a8'), new Character('\u00a9'));
        UNICODE2TI.put(new Character('\u00aa'), new Character('\u00aa'));
        UNICODE2TI.put(new Character('\u00d7'), new Character('\u00ab'));
        UNICODE2TI.put(new Character('\u00a9'), new Character('\u00ac'));
        UNICODE2TI.put(new Character('\u00aa'), new Character('\u00ad'));
        UNICODE2TI.put(new Character('\u00a8'), new Character('\u00ae'));
        UNICODE2TI.put(new Character('\u00ab'), new Character('\u00af'));
        UNICODE2TI.put(new Character('\u00ac'), new Character('\u00b0'));
        UNICODE2TI.put(new Character('\u00ad'), new Character('\u00b1'));
        UNICODE2TI.put(new Character('\u00ae'), new Character('\u00b2'));
        UNICODE2TI.put(new Character('\u00af'), new Character('\u00b3'));
        UNICODE2TI.put(new Character('\u00b0'), new Character('\u00b4'));
        UNICODE2TI.put(new Character('\u00b1'), new Character('\u00b5'));
        UNICODE2TI.put(new Character('\u00b6'), new Character('\u00b6'));
        UNICODE2TI.put(new Character('\u00b2'), new Character('\u00b7'));
        UNICODE2TI.put(new Character('\u00b3'), new Character('\u00b8'));
        UNICODE2TI.put(new Character('\u00b4'), new Character('\u00b9'));
        UNICODE2TI.put(new Character('\u00b5'), new Character('\u00ba'));
        UNICODE2TI.put(new Character('\u00de'), new Character('\u00bb'));
        UNICODE2TI.put(new Character('\u00b6'), new Character('\u00bc'));
        UNICODE2TI.put(new Character('\u00b7'), new Character('\u00bd'));
        UNICODE2TI.put(new Character('\u00b8'), new Character('\u00be'));
        UNICODE2TI.put(new Character('\u00b9'), new Character('\u00bf'));
        UNICODE2TI.put(new Character('\u00c0'), new Character('\u00c0'));
        UNICODE2TI.put(new Character('\u00c1'), new Character('\u00c1'));
        UNICODE2TI.put(new Character('\u00c2'), new Character('\u00c2'));
        UNICODE2TI.put(new Character('\u00c3'), new Character('\u00c3'));
        UNICODE2TI.put(new Character('\u00c4'), new Character('\u00c4'));
        UNICODE2TI.put(new Character('\u00c5'), new Character('\u00c5'));
        UNICODE2TI.put(new Character('\u00e6'), new Character('\u00c6'));
        UNICODE2TI.put(new Character('\u00c7'), new Character('\u00c7'));
        UNICODE2TI.put(new Character('\u00c8'), new Character('\u00c8'));
        UNICODE2TI.put(new Character('\u00c9'), new Character('\u00c9'));
        UNICODE2TI.put(new Character('\u00ca'), new Character('\u00ca'));
        UNICODE2TI.put(new Character('\u00cb'), new Character('\u00cb'));
        UNICODE2TI.put(new Character('\u00cd'), new Character('\u00cc'));
        UNICODE2TI.put(new Character('\u00cc'), new Character('\u00cd'));
        UNICODE2TI.put(new Character('\u00cd'), new Character('\u00ce'));
        UNICODE2TI.put(new Character('\u00cf'), new Character('\u00cf'));
        UNICODE2TI.put(new Character('\u00d0'), new Character('\u00d0'));
        UNICODE2TI.put(new Character('\u00d1'), new Character('\u00d1'));
        UNICODE2TI.put(new Character('\u00d2'), new Character('\u00d2'));
        UNICODE2TI.put(new Character('\u00d3'), new Character('\u00d3'));
        UNICODE2TI.put(new Character('\u00d4'), new Character('\u00d4'));
        UNICODE2TI.put(new Character('\u00d5'), new Character('\u00d5'));
        UNICODE2TI.put(new Character('\u00d6'), new Character('\u00d6'));
        UNICODE2TI.put(new Character('x'), new Character('\u00d7'));
        UNICODE2TI.put(new Character('\u00d8'), new Character('\u00d8'));
        UNICODE2TI.put(new Character('\u00d9'), new Character('\u00d9'));
        UNICODE2TI.put(new Character('\u00da'), new Character('\u00da'));
        UNICODE2TI.put(new Character('\u00db'), new Character('\u00db'));
        UNICODE2TI.put(new Character('\u00dc'), new Character('\u00dc'));
        UNICODE2TI.put(new Character('\u00dd'), new Character('\u00dd'));
        UNICODE2TI.put(new Character('\u00fe'), new Character('\u00de'));
        UNICODE2TI.put(new Character('\u00df'), new Character('\u00df'));
        UNICODE2TI.put(new Character('\u00e0'), new Character('\u00e0'));
        UNICODE2TI.put(new Character('\u00e1'), new Character('\u00e1'));
        UNICODE2TI.put(new Character('\u00e2'), new Character('\u00e2'));
        UNICODE2TI.put(new Character('\u00e3'), new Character('\u00e3'));
        UNICODE2TI.put(new Character('\u00e4'), new Character('\u00e4'));
        UNICODE2TI.put(new Character('\u00e5'), new Character('\u00e5'));
        UNICODE2TI.put(new Character('\u00e6'), new Character('\u00e6'));
        UNICODE2TI.put(new Character('\u00e7'), new Character('\u00e7'));
        UNICODE2TI.put(new Character('\u00e8'), new Character('\u00e8'));
        UNICODE2TI.put(new Character('\u00e9'), new Character('\u00e9'));
        UNICODE2TI.put(new Character('\u00ea'), new Character('\u00ea'));
        UNICODE2TI.put(new Character('\u00eb'), new Character('\u00eb'));
        UNICODE2TI.put(new Character('\u00ec'), new Character('\u00ec'));
        UNICODE2TI.put(new Character('\u00ed'), new Character('\u00ed'));
        UNICODE2TI.put(new Character('\u00ee'), new Character('\u00ee'));
        UNICODE2TI.put(new Character('\u00ef'), new Character('\u00ef'));
        UNICODE2TI.put(new Character('\u00f0'), new Character('\u00f0'));
        UNICODE2TI.put(new Character('\u00f1'), new Character('\u00f1'));
        UNICODE2TI.put(new Character('\u00f2'), new Character('\u00f2'));
        UNICODE2TI.put(new Character('\u00f3'), new Character('\u00f3'));
        UNICODE2TI.put(new Character('\u00f4'), new Character('\u00f4'));
        UNICODE2TI.put(new Character('\u00f5'), new Character('\u00f5'));
        UNICODE2TI.put(new Character('\u00f6'), new Character('\u00f6'));
        UNICODE2TI.put(new Character('\u00f7'), new Character('\u00f7'));
        UNICODE2TI.put(new Character('\u00f8'), new Character('\u00f8'));
        UNICODE2TI.put(new Character('\u00f9'), new Character('\u00f9'));
        UNICODE2TI.put(new Character('\u00fa'), new Character('\u00fa'));
        UNICODE2TI.put(new Character('\u00fb'), new Character('\u00fb'));
        UNICODE2TI.put(new Character('\u00fc'), new Character('\u00fc'));
        UNICODE2TI.put(new Character('\u00fd'), new Character('\u00fd'));
        UNICODE2TI.put(new Character('\u00fe'), new Character('\u00fe'));
        UNICODE2TI.put(new Character('\u00ff'), new Character('\u00ff'));
    }
}

