/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.utilities;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Hashtable;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultEditorKit;
import net.wordrider.utilities.Consts;

public final class Utils {
    public static final int DEBUG_LOG = 0;
    public static final int INFO_LOG = 1;
    public static final int WARN_LOG = 2;
    public static final int ERROR_LOG = 3;
    private static final String[] INFO = new String[]{"-[DEBUG]-", "-[INFO ]-", "-[WARN ]-", "-[ERROR]-"};
    private static final Hashtable resources = new Hashtable(1);
    private static final SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss:SSS");

    private Utils() {
    }

    public static final String generateXorString(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append((char)(cArray[i] ^ 0x893C));
            }
            return stringBuffer.toString();
        }
        return "";
    }

    public static boolean isDefinedForLog(int n) {
        return n >= Consts.LOG_SEVERITY;
    }

    public static String addParam(String string, String string2, String string3) {
        String string4;
        try {
            string4 = URLEncoder.encode(string3, "ISO-8859-2");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = "";
            Utils.processException(unsupportedEncodingException);
        }
        String string5 = string2 + "=" + string4;
        return string.length() > 0 ? string + "&" + string5 : string5;
    }

    public static void log(int n, String string) {
        if (n >= Consts.LOG_SEVERITY) {
            System.out.println(format.format(Calendar.getInstance().getTime()) + INFO[n] + string);
        }
    }

    public static void logDebug(String string) {
        System.out.println(format.format(Calendar.getInstance().getTime()) + INFO[0] + string);
    }

    public static void processException(Exception exception) {
        System.err.println("WordRider 0.55 Error : " + exception.getMessage());
        if (3 >= Consts.LOG_SEVERITY) {
            exception.printStackTrace();
        }
    }

    public static final String loadFile(String string) {
        if (resources.containsKey(string)) {
            return (String)resources.get(string);
        }
        StringBuffer stringBuffer = new StringBuffer(2000);
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Utils.class.getResourceAsStream(string)));
            char[] cArray = new char[2000];
            while ((n = bufferedReader.read(cArray)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Utils.processException(exception);
        }
        resources.put(string, stringBuffer.toString());
        return stringBuffer.toString();
    }

    public static final String shortenFileName(String string, int n) {
        int n2 = string.length();
        if (n2 < n) {
            return string;
        }
        String string2 = File.separator;
        String[] stringArray = string.split(string2.equals("\\") ? "\\\\" : string2);
        int n3 = stringArray.length;
        if (n3 > 4) {
            int n4 = 0;
            for (int i = 2; i < n3 - 2 && n2 - (n4 += stringArray[i].length()) + 3 >= n; ++i) {
            }
            StringBuffer stringBuffer = new StringBuffer(n2 - n4 + 3);
            stringBuffer.append(stringArray[0]).append(string2).append(stringArray[1]).append(string2).append("...");
            for (int i = i + 1; i < n3; ++i) {
                stringBuffer.append(string2);
                stringBuffer.append(stringArray[i]);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public static String getExtension(File file) {
        String string = null;
        String string2 = file.getName();
        int n = string2.lastIndexOf(46);
        if (n > 0 && n < string2.length() - 1) {
            string = string2.substring(n + 1).toLowerCase();
        }
        return string;
    }

    public static final void addKeyActions(JComponent jComponent) {
        InputMap inputMap = jComponent.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(155, 2), new DefaultEditorKit.CopyAction());
        inputMap.put(KeyStroke.getKeyStroke(155, 1), new DefaultEditorKit.PasteAction());
        inputMap.put(KeyStroke.getKeyStroke(127, 1), new DefaultEditorKit.CutAction());
        jComponent.setInputMap(0, inputMap);
    }
}

