/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.area.actions;

/**
 * @author Vity
 */

import net.wordrider.core.Lng;
import net.wordrider.utilities.Swinger;

import javax.swing.*;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 */
public final class CutAction extends DefaultEditorKit.CutAction {
    private static final CutAction instance = new CutAction();
    private static final String CODE = "CutAction";

    public static CutAction getInstance() {
        return instance;
    }

    private CutAction() {
        putValue(Action.NAME, Lng.getLabel(CODE));
        putValue(Action.SHORT_DESCRIPTION, Lng.getHint(CODE));
        putValue(Action.MNEMONIC_KEY, new Integer(Lng.getMnemonic(CODE)));
        putValue(Action.ACCELERATOR_KEY, KeyStroke.getKeyStroke(KeyEvent.VK_X, InputEvent.CTRL_MASK));
        putValue(Action.SMALL_ICON, Swinger.getIcon("cut.gif"));
    }

    public boolean isEnabled() {
        final JTextComponent comp = getFocusedComponent();
        return comp != null && comp.isEditable()
                && comp.isEnabled()
                && comp.getSelectedText() != null;
    }
}
