/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.dialogs.settings.SettingsDialog;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;

/**
 * @author Vity
 */
public final class ShowUserSettings extends CoreAction {
    private final static ShowUserSettings instance = new ShowUserSettings();
    private final static String CODE = "ShowUserSettingsAction";

    public static ShowUserSettings getInstance() {
        return instance;
    }

    private ShowUserSettings() {
        super(CODE, KeyStroke.getKeyStroke(KeyEvent.VK_F10, InputEvent.CTRL_MASK), "options.gif");    //call to super
    }

    public final void actionPerformed(final ActionEvent e) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                new SettingsDialog(getMainFrame());
                AreaManager.getInstance().grabActiveFocus();
            }
        });
    }

    public void setUpSendMethod() {
        new SettingsDialog(getMainFrame(), true);
    }
}
