/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.utilities.BrowserControl;

import javax.swing.*;
import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public class WebAction extends CoreAction{
    private String url;


    public WebAction(String url) {
        this.url = url;
    }

    protected WebAction(final String actionCode, final KeyStroke keyStroke, final String smallIcon, final String url) {
        super(actionCode, keyStroke, smallIcon);
        if (url == null)
            throw new IllegalArgumentException("URL argument cannot be null");
        this.url = url;
    }


    public void actionPerformed(ActionEvent e) {
        BrowserControl.showURL(url);
    }
}
