/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core;

import net.wordrider.utilities.Consts;

import java.awt.*;
import java.net.URL;
import java.net.URLClassLoader;

/**
 * @author Vity
 */
final class MainAppSplash {
    private MainAppSplash() {
    }

    private static boolean containsInterruble(final String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-") && !(arg.equals("-d") || arg.equals("-debug") || arg.equals("--debug")))
                return true;
        }
        return false;
    }

    @SuppressWarnings({"RedundantArrayCreation"})
    public static void main(final String[] args) {
//        System.out.println(System.getProperty("sun.java2d.translaccel", null));
//        System.out.println(System.getProperty("sun.java2d.opengl", null));
        Frame splashFrame = null;
        if (!(containsInterruble(args) || OneInstanceServer.isWordRiderInUse())) {        
            final URL imageURL = ((URLClassLoader) MainAppSplash.class.getClassLoader()).findResource(Consts.IMAGESDIR + "splash.gif");
            if (imageURL != null) {
                splashFrame = SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(imageURL));
            } else {
                System.err.println("Splash image not found");
            }
        }
        try {
            Class.forName(MainApp.class.getName())
                    .getMethod("main", new Class[]{String[].class}).invoke(null, new Object[]{args});
        } catch (Throwable e) {
            e.printStackTrace();
            System.err.flush();
            System.exit(-1);
        }

        // Dispose the splash screen
        // -------------------------
        if (splashFrame != null) splashFrame.dispose();
    }
}