/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.actions;

import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileInstance;

import java.awt.event.ActionEvent;

/**
 * @author Vity
 */
public final class CloseAllButThisAction extends CoreAction {
    private static final CloseAllButThisAction instance = new CloseAllButThisAction();
    private static final String CODE = "CloseAllButThisAction";

    private CloseAllButThisAction() {
        super(CODE, null, null);
    }


    public static CloseAllButThisAction getInstance() {
        return instance;
    }

    @Override
    public boolean isEnabled() {
        return AreaManager.getInstance().getOpenedInstanceCount() > 1;
    }


    private static boolean closeAll() {
        final AreaManager areaManager = AreaManager.getInstance();
        final FileInstance activeInstance = areaManager.getActiveInstance();
        //closes all except the selected on the list
        for (FileInstance instance : areaManager.getOpenedInstances()) {
            if (!instance.equals(activeInstance) && !instance.isModified()) { //is not modified list
                areaManager.closeInstanceHard(instance);
            }
        }
        for (FileInstance instance : areaManager.getOpenedInstances()) {
            if (!instance.equals(activeInstance)) {
                areaManager.setActivateFileInstance(instance);
                if (!SaveFileAction.save(false))
                    return false;
                areaManager.closeActiveInstance();
            }
        }
        return true;
    }

    public final void actionPerformed(final ActionEvent e) {
        closeAll();
    }
}
