/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.managers;

import net.wordrider.core.MainApp;
import net.wordrider.core.managers.interfaces.IAreaChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.plugintools.PluginTool;

import javax.swing.*;

/**
 * @author Vity
 */
public final class PluginToolsManager extends TabManager<PluginTool> implements IAreaChangeListener {

    public PluginToolsManager() {
        super(JTabbedPane.LEFT);    //call to super
    }


    public final void addPluginTool(final PluginTool pluginTool) {
        registerNewOne(pluginTool, false);
    }


    public void areaActivated(AreaChangeEvent event) {
        updateFileInstance(event.getFileInstance());
    }

    public void areaDeactivated(AreaChangeEvent event) {
        updateFileInstance(null);
    }


    private void updateFileInstance(IFileInstance instance) {
        final PluginTool tool = getActiveInstance();
        if (tool != null)
            tool.setFileInstance(instance);
    }

    public final void selectPluginTool(final PluginTool pluginTool) {
        tabbedPane.setSelectedComponent(pluginTool.getComponent());
    }

    public static PluginToolsManager getInstance() {
        return MainApp.getInstance().getMainAppFrame().getManagerDirector().getPluginToolsManager();
    }
}
