/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.swing;

import javax.swing.*;
import java.awt.*;

public class CompTitledPane extends JPanel {
    private CompTitledBorder border;
    private JComponent component;
    private JPanel panel;

    public CompTitledPane(JComponent component) {
        this.component = component;
        border = new CompTitledBorder(component);
        border.setTitleJustification(5);
        setBorder(border);
        panel = new JPanel();
        setLayout(new BorderLayout());
        this.add(component);
        this.add(panel);
    }

    public JComponent getTitleComponent() {
        return component;
    }

    public void setTitleComponent(JComponent newComponent) {
        remove(component);
        add(newComponent);
        border.setTitleComponent(newComponent);
        component = newComponent;
    }

    public JPanel getContentPane() {
        return panel;
    }

    public void doLayout() {
        //  super.doLayout();
        Rectangle rect = getBounds();
        Insets insets = getInsets();
        rect.x = 0;
        rect.y = 0;
        Rectangle compR = border.getComponentRect(rect, insets);
        component.setBounds(compR);
        rect.x += insets.left;
        rect.y += insets.top;
        rect.width -= insets.left + insets.right;
        rect.height -= insets.top + insets.bottom;
        panel.setBounds(rect);
    }
}
