/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.core.swing;

import java.util.regex.PatternSyntaxException;

/**
 * @author Vity
 */
public class SwingUtils {
    private SwingUtils() {
    }

    public static String getMessage(final PatternSyntaxException e, final String desc, final String desc2) {
        StringBuilder sb = new StringBuilder();
        sb.append(desc);
        final int index = e.getIndex();
        if (index >= 0) {
            sb.append(' ');
            sb.append(desc2);
            sb.append(' ');
            sb.append(index);
        }
        sb.append('\n');
        sb.append(e.getPattern());
        if (index >= 0) {
            sb.append('\n');
            for (int i = 0; i < index; i++) sb.append(' ');
            sb.append('^');
        }
        return sb.toString();
    }
}
