/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

/**
 * @author Vity
 */
public class BurkeFilter extends DitherRaster {

    protected void performEffect() {

        for (int y = 0; y < height; y++) {
            for (int x = 0; x < width; x++) {
                final int actualIndex = y * width + x;
                final int pixel = pixels[actualIndex];
                pixels[actualIndex] = pixels[actualIndex] <= threshold ? 0 : 255;
                final int k = pixel - pixels[actualIndex];
                final int l = k >> 2;
                final int i = k >> 3;
                final int j = k >> 4;
                if (x < width - 1)
                    pixels[actualIndex + 1] += l;
                if (x < width - 2)
                    pixels[actualIndex + 2] += i;
                if (y < height - 1) {
                    int k2 = (y + 1) * width + x;
                    if (x > 1)
                        pixels[k2 - 2] += j;
                    if (x > 0)
                        pixels[k2 - 1] += i;
                    pixels[k2] += l;
                    if (x < width - 1)
                        pixels[k2 + 1] += i;
                    if (x < width - 2)
                        pixels[k2 + 2] += j;
                }
            }

        }
        quantize();
    }

}
