/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

import java.awt.image.RGBImageFilter;

/**
 * @author Vity
 */
public final class ContrastFilter extends RGBImageFilter {
    private float gain = 1;

    public ContrastFilter() {
        super();    //call to super
        canFilterIndexColorModel = true;
    }

    public final void setGain(final int value) {
        this.gain = (float) ((value + 100) / 100.0);
    }

    private int cont(final int in) {
        return (int) ((in < 128) ? (in / gain) : in * gain);
//        if (in < 128)
//            return (int) ((gain > 1) ? in / gain : in * gain);
//        else
//            return (int) ((gain > 1) ? in * gain : in / gain);
    }

    public final int filterRGB(final int x, final int y, final int rgb) {
        int r = cont((rgb >> 16) & 0xff);
        int g = cont((rgb >> 8) & 0xff);
        int b = cont(rgb & 0xff);
        r = Math.min(Math.max(0, r), 255);
        g = Math.min(Math.max(0, g), 255);
        b = Math.min(Math.max(0, b), 255);
        return (rgb & 0xff000000 | r << 16 | g << 8 | b);
    }
}

