/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.dialogs.pictures.filters;

/**
 * @author Vity
 */

import java.util.Random;

public final class RandomRaster extends DitherRaster {
    private final Random whiteNoise = new Random();
    private int random;
    private int rcount = 0;

    public final int getNoiseyPixel(final int x, final int y, int actualPixel) {
        //   final int a = pix & 0xff000000;
//        int r = (pix >> 16) & 255;
//        int g = (pix >> 8) & 255;
//        int b = pix & 255;
//        int actualPixel = getPixel(x, y);

        if (rcount == 0) {
            random = whiteNoise.nextInt();
            rcount = 4;
        }

        int noise = (random & 255) - 128;
        noise = (threshold * noise) >> 8;
        random >>= 8;
        rcount -= 1;

//        r += noise;
//        g += noise;
        actualPixel += noise;

//        r = ((r & ~255) == 0) ? r : ((r < 0) ? 0 : 255);
//        g = ((g & ~255) == 0) ? g : ((g < 0) ? 0 : 255);
        actualPixel = ((actualPixel & ~255) == 0) ? actualPixel : ((actualPixel < 0) ? 0 : 255);

//        r = quantize[r] << 16;
//        g = quantize[g] << 8;
        actualPixel = quantize[actualPixel];
        return (0xff000000 | actualPixel << 16 | actualPixel << 8 | actualPixel);
    }
}