/*
* Copyright (C) 2004 Ladislav Vitasek
* info@wordrider.net
* http://www.wordrider.net
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public License
* as published by the Free Software Foundation; either version 2
* of the License, or any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package net.wordrider.files.ti68kformat;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;

/**
 * @author Vity
 */
public abstract class FastTIFileReader extends TIFileReader {
    byte[] byteContent = null;
    private byte[] checksum = null;
    private File file = null;

    public byte[] getChecksum() {
        return checksum;
    }

    public byte[] getByteContent() {
        return byteContent;
    }

    public File getFile() {
        return file;
    }

    public void setByteContent(final byte[] byteContent) {
        this.byteContent = byteContent;
        updateChecksum();
    }

    private void updateChecksum() {
        final int size = byteContent.length;
        int sum = 0;
        for (int i = 0; i < size; ++i)
            sum += byteContent[i];
        char charSum = (char) sum;
        checksum[0] = (byte) charSum;
        checksum[1] = (byte) (charSum >> 8);
    }

    protected void storeFileInformation(File file) {
        this.file = file;
    }


    protected void readContent(DataInputStream stream) throws IOException {
        final int contentSize = (int) file.length() - 0x52 - 2;
        if (contentSize <= 0)
            throw new IOException("Invalid file size");
        byteContent = new byte[contentSize]; //-2 = checksum
        stream.readFully(byteContent);
        fileInfo.setVarName(fileInfo.getVarName());
        fileInfo.setFolderName(fileInfo.getFolderName());
    }

    protected char getCheckSum() {
        return 0;
    }

    protected char readChecksum(final DataInputStream stream) throws IOException {
        checksum = new byte[2]; //-2 = checksum
        stream.readFully(checksum);
        return 0;
    }
}
