/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area.actions;

import java.awt.event.ActionEvent;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;
import net.wordrider.area.RiderStyles;
import net.wordrider.area.actions.ChangeParagraphStyleAction;
import net.wordrider.area.actions.StyledAreaAction;
import net.wordrider.core.MainApp;

public final class MarginXAction
extends ChangeParagraphStyleAction {
    private static final MarginXAction instance = new MarginXAction();
    private static final String CODE = "MarginXAction";

    public static MarginXAction getInstance() {
        return instance;
    }

    private MarginXAction() {
        super(CODE, KeyStroke.getKeyStroke(52, 8), "marg_x.gif");
    }

    public final void actionPerformed(ActionEvent actionEvent) {
        JComboBox jComboBox = MarginXAction.getMarginCombo();
        if (jComboBox != null) {
            ComboBoxEditor comboBoxEditor = jComboBox.getEditor();
            String string = comboBoxEditor.getItem().toString();
            if (string != null && string.length() > 0) {
                int n = Integer.parseInt(string);
                this.style = RiderStyles.getMarginXStyle(n);
                MarginXAction.updateComboData(jComboBox);
                super.actionPerformed(actionEvent);
            } else {
                jComboBox.getEditor().selectAll();
                StyledAreaAction.updateStatus();
            }
        }
    }

    private static JComboBox getMarginCombo() {
        return MainApp.getInstance().getMainAppFrame().getManagerDirector().getToolbarManager().getInputMarginXCombo();
    }

    public static void updateComboData(JComboBox jComboBox) {
        Object[] objectArray;
        ComboBoxModel comboBoxModel = jComboBox.getModel();
        int n = comboBoxModel.getSize();
        if (n != (objectArray = RiderStyles.getVariableMargins()).length) {
            jComboBox.setModel(new DefaultComboBoxModel<Object>(objectArray));
        }
    }
}

