/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.actions;

import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.text.Document;
import net.wordrider.area.RiderArea;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.DocumentProducer;
import net.wordrider.core.actions.FileProcessor;
import net.wordrider.core.actions.LoadFileAction;

abstract class AbstractFileProcessor
implements FileProcessor {
    static final Logger logger = Logger.getLogger(AbstractFileProcessor.class.getName());
    private final File file;

    public AbstractFileProcessor(File file) {
        this.file = file;
    }

    public boolean process() {
        AppPrefs.storeProperty("settings.lastOpenFolder", this.getFile().getAbsolutePath());
        return false;
    }

    File getFile() {
        return this.file;
    }

    boolean loadDocument(RiderArea riderArea, DocumentProducer documentProducer) {
        LoadFileAction loadFileAction = new LoadFileAction(documentProducer);
        loadFileAction.init();
        Document document = (Document)loadFileAction.get();
        if (document != null) {
            riderArea.setDocument(document);
            riderArea.setCursor(Cursor.getDefaultCursor());
            return true;
        }
        return false;
    }

    Frame getMainFrame() {
        return MainApp.getInstance().getMainAppFrame();
    }
}

