/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ComboBoxOption
implements IOptionable<JComboBox>,
ItemListener {
    private final Object initValue;
    private Object applyedValue;
    private final Object defaultValue = null;
    private boolean wasChanged = false;
    private final OptionsGroupManager optionsGroupManager;
    private IOptionGroup group = null;
    private JComboBox combo;

    public ComboBoxOption(OptionsGroupManager optionsGroupManager, ComboBoxModel comboBoxModel, IOptionGroup iOptionGroup) {
        this.combo = new JComboBox(comboBoxModel);
        this.initValue = this.applyedValue = this.combo.getSelectedItem();
        this.group = iOptionGroup;
        this.combo.setSelectedItem(comboBoxModel.getSelectedItem());
        this.optionsGroupManager = optionsGroupManager;
        this.combo.addItemListener(this);
    }

    private void updateValue() {
        this.wasChanged = !this.applyedValue.equals(this.combo.getSelectedItem());
        this.optionsGroupManager.makeChange(this);
    }

    @Override
    public final void itemStateChanged(ItemEvent itemEvent) {
        this.updateValue();
    }

    @Override
    public final void setDefault() {
        if (this.defaultValue != null) {
            this.combo.setSelectedItem(this.defaultValue);
        }
    }

    @Override
    public final void restorePrevious() {
        this.combo.setSelectedItem(this.initValue);
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    @Override
    public void applyChange() {
        this.wasChanged = false;
        this.applyedValue = this.combo.getSelectedItem();
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    public JComboBox getComponent() {
        return this.combo;
    }
}

