/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.core.managers;

import java.io.File;
import java.util.Iterator;
import java.util.Stack;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.managers.FileChangeEvent;
import net.wordrider.core.managers.MenuManager;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;

public final class RecentFilesManager
implements IFileChangeListener {
    private final MenuManager menuManager;
    private final Stack<File> recentFilesList = new Stack();
    private static final String RECENT_PREFERENCES = "recent";

    public RecentFilesManager(MenuManager menuManager) {
        this.menuManager = menuManager;
        this.loadRecentFiles();
    }

    private static int getMaxRecentFilesSettings() {
        return AppPrefs.getProperty("settings.recentcount", 7);
    }

    private void loadRecentFiles() {
        String string;
        String string2;
        int n = 0;
        while ((string2 = AppPrefs.getProperty(string = RECENT_PREFERENCES + n, null)) != null) {
            if (string2.length() > 0) {
                this.recentFilesList.add(0, new File(string2));
                AppPrefs.removeProperty(string);
            }
            ++n;
        }
        n = RecentFilesManager.getMaxRecentFilesSettings();
        if (this.recentFilesList.size() > n) {
            this.recentFilesList.setSize(n);
        }
        if (!this.recentFilesList.isEmpty()) {
            this.buildRecentFileMenu();
        }
    }

    private void fileWasOpened(File file) {
        if (file == null) {
            return;
        }
        int n = this.recentFilesList.indexOf(file);
        if (n != -1) {
            this.recentFilesList.remove(n);
            this.buildRecentFileMenu();
        }
    }

    public void fileWasOpened(FileChangeEvent fileChangeEvent) {
        this.fileWasOpened(fileChangeEvent.getFileInstance().getFile());
    }

    public void fileWasClosed(FileChangeEvent fileChangeEvent) {
        IFileInstance iFileInstance = fileChangeEvent.getFileInstance();
        if (!iFileInstance.hasAssignedFile()) {
            return;
        }
        if (this.recentFilesList.indexOf(iFileInstance.getFile()) < 0) {
            this.recentFilesList.add(0, iFileInstance.getFile());
            int n = RecentFilesManager.getMaxRecentFilesSettings();
            if (this.recentFilesList.size() > n) {
                this.recentFilesList.setSize(n);
            }
            this.buildRecentFileMenu();
        }
    }

    public void buildRecentFileMenu() {
        this.menuManager.updateRecentMenu(this.recentFilesList);
    }

    public final void removeBadFile(File file) {
        this.fileWasOpened(file);
    }

    public final void storeRecentFiles() {
        int n = this.recentFilesList.size() - 1;
        Iterator iterator = this.recentFilesList.iterator();
        while (iterator.hasNext()) {
            AppPrefs.storeProperty(RECENT_PREFERENCES + n, ((File)iterator.next()).toString());
            --n;
        }
    }
}

