/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import net.wordrider.area.ColorStyles;
import net.wordrider.dialogs.settings.IOptionGroup;
import net.wordrider.dialogs.settings.IOptionable;
import net.wordrider.dialogs.settings.OptionsGroupManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ColorOption
extends JButton
implements IOptionable<JButton> {
    private final Color initValue;
    private Color applyedValue;
    private Color selectedValue;
    private final OptionsGroupManager optionsGroupManager;
    private static final Dimension colorPanelDimension = new Dimension(34, 19);
    private static final ActionListener clickAction = new ButtonClick();
    private boolean wasChanged = false;
    private IOptionGroup group = null;
    private int colorCode;

    public ColorOption(OptionsGroupManager optionsGroupManager, int n, IOptionGroup iOptionGroup) {
        this(optionsGroupManager, ColorStyles.getColor(n), iOptionGroup);
        this.colorCode = n;
    }

    private ColorOption(OptionsGroupManager optionsGroupManager, Color color, IOptionGroup iOptionGroup) {
        this.group = iOptionGroup;
        this.optionsGroupManager = optionsGroupManager;
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.addActionListener(clickAction);
        this.setOpaque(false);
        this.applyedValue = this.selectedValue = color;
        this.initValue = this.selectedValue;
        this.setFont(this.getFont().deriveFont(0, 7.0f));
        this.setText(" ");
        this.setRolloverEnabled(false);
        this.setFocusPainted(false);
        this.setFocusable(true);
        this.setMinimumSize(colorPanelDimension);
        this.setMaximumSize(colorPanelDimension);
        this.setPreferredSize(colorPanelDimension);
    }

    @Override
    public final void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
        graphics.drawRect(4, 3, this.getWidth() - 8 - 1, this.getHeight() - 6 - 2);
        graphics.setColor(this.selectedValue);
        graphics.fillRect(5, 4, this.getWidth() - 8 - 2, this.getHeight() - 6 - 3);
    }

    private void setSelectedValue(Color color) {
        if (color != null && !this.selectedValue.equals(color)) {
            this.selectedValue = color;
            this.wasChanged = !this.applyedValue.equals(color);
            this.optionsGroupManager.makeChange(this);
            this.repaint();
        }
    }

    private Color getDefault() {
        return ColorStyles.getDefaultColor(this.colorCode);
    }

    @Override
    public final void applyChange() {
        ColorStyles.setColor(this.colorCode, this.selectedValue);
        this.wasChanged = false;
        this.applyedValue = this.selectedValue;
    }

    @Override
    public final void restorePrevious() {
        this.selectedValue = this.initValue;
    }

    @Override
    public final IOptionGroup getOptionsGroup() {
        return this.group;
    }

    @Override
    public final void setDefault() {
        this.setSelectedValue(this.getDefault());
    }

    @Override
    public final boolean wasChanged() {
        return this.wasChanged;
    }

    private Color getSelectedValue() {
        return this.selectedValue;
    }

    public JButton getComponent() {
        return this;
    }

    private static final class ButtonClick
    implements ActionListener {
        private ButtonClick() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            ColorOption colorOption = (ColorOption)actionEvent.getSource();
            colorOption.setSelectedValue(JColorChooser.showDialog(colorOption.getParent(), "Choose color", colorOption.getSelectedValue()));
        }
    }
}

