/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.JPanel;

final class SelectablePanel
extends JPanel {
    public SelectablePanel() {
        super(new SettingsCardLayout());
    }

    private int getVisibleChildIndex() {
        int n = this.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            return i;
        }
        return -1;
    }

    public final void showCard(Component component) {
        int n;
        if (component.getParent() == null || !component.getParent().equals(this)) {
            this.add(component);
        }
        if ((n = this.getVisibleChildIndex()) != -1) {
            this.getComponent(n).setVisible(false);
        }
        component.setVisible(true);
        this.revalidate();
        this.repaint();
    }

    public final Component getActiveCard() {
        int n = this.getVisibleChildIndex();
        if (n != -1) {
            return this.getComponent(n);
        }
        return null;
    }

    private static final class SettingsCardLayout
    implements LayoutManager {
        private SettingsCardLayout() {
        }

        public final void addLayoutComponent(String string, Component component) {
            if (string != null) {
                component.setName(string);
            }
            component.setVisible(component.getParent().getComponentCount() == 1);
        }

        public final void removeLayoutComponent(Component component) {
            Container container;
            if (component.isVisible() && (container = component.getParent()).getComponentCount() > 0) {
                container.getComponent(0).setVisible(true);
            }
        }

        public final Dimension preferredLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(n2, n3);
        }

        public final Dimension minimumLayoutSize(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            int n2 = insets.left + insets.right;
            int n3 = insets.top + insets.bottom;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Dimension dimension = component.getMinimumSize();
                if (dimension.width > n2) {
                    n2 = dimension.width;
                }
                if (dimension.height <= n3) continue;
                n3 = dimension.height;
            }
            return new Dimension(n2, n3);
        }

        public final void layoutContainer(Container container) {
            int n = container.getComponentCount();
            Insets insets = container.getInsets();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (!component.isVisible()) continue;
                Rectangle rectangle = container.getBounds();
                int n2 = rectangle.width - insets.left + insets.right;
                int n3 = rectangle.height - insets.top + insets.bottom;
                component.setBounds(insets.left, insets.top, n2, n3);
                break;
            }
        }
    }
}

