/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import info.clearthought.layout.TableLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.text.JTextComponent;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.SendToCalcAction;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.core.swing.URLMouseClickAdapter;
import net.wordrider.dialogs.JButtonGroup;
import net.wordrider.dialogs.settings.DefaultOptionsGroup;
import net.wordrider.dialogs.settings.JTextFieldOption;
import net.wordrider.dialogs.settings.RadioOption;
import net.wordrider.dialogs.settings.SettingsDialog;
import net.wordrider.dialogs.settings.SettingsPanel;
import net.wordrider.utilities.Swinger;
import net.wordrider.utilities.Utils;

final class SendMethodSettingsPanel
extends SettingsPanel {
    public SendMethodSettingsPanel(SettingsDialog settingsDialog, String string) {
        super(settingsDialog, string);
    }

    protected final void init() {
        String[] stringArray;
        DefaultOptionsGroup defaultOptionsGroup = new DefaultOptionsGroup();
        int n = SendToCalcAction.getMethodSelected();
        String string = SendToCalcAction.getDefaultPath(1);
        JTextFieldOption jTextFieldOption = new JTextFieldOption(this.manager, null, "settings.ticonnectPath", string, defaultOptionsGroup);
        String string2 = SendToCalcAction.getDefaultPath(2);
        final JTextFieldOption jTextFieldOption2 = new JTextFieldOption(this.manager, null, "settings.tilpPath", string2, defaultOptionsGroup);
        final JTextFieldOption jTextFieldOption3 = new JTextFieldOption(this.manager, null, "settings.tilpParameters", "", defaultOptionsGroup);
        final JTextField jTextField = jTextFieldOption.getComponent();
        final JButton jButton = new JButton("\u2026");
        Dimension dimension = new Dimension(20, jTextField.getPreferredSize().height);
        jButton.setPreferredSize(dimension);
        final JButton jButton2 = new JButton("\u2026");
        jButton2.setPreferredSize(dimension);
        SimpleFileFilter simpleFileFilter = new SimpleFileFilter(new String[]{"TISendTo.exe"}, "TISendTo.exe (TI Connect)");
        if (Utils.isWindows()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "tilp2.exe";
            stringArray = stringArray2;
            stringArray2[1] = "tilp.exe";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "tilp2";
            stringArray = stringArray3;
            stringArray3[1] = "tilp";
        }
        SimpleFileFilter simpleFileFilter2 = new SimpleFileFilter(stringArray, Utils.isWindows() ? "tilp2.exe, tilp.exe (TiLP)" : "tilp2, tilp (TiLP)");
        jButton.addActionListener(new SelFileAction(jTextField, simpleFileFilter));
        jButton2.addActionListener(new SelFileAction(jTextFieldOption2.getComponent(), simpleFileFilter2));
        RadioOption radioOption = new RadioOption(this.manager, "settings.radioTIConnect", "settings.sendMethod", 1, n, defaultOptionsGroup);
        RadioOption radioOption2 = new RadioOption(this.manager, "settings.radioTiLP", "settings.sendMethod", 2, n, defaultOptionsGroup){

            protected void updateValue() {
                super.updateValue();
                boolean bl = this.getComponent().isSelected();
                jTextField.setEnabled(!bl);
                jTextFieldOption2.getComponent().setEnabled(bl);
                jTextFieldOption3.getComponent().setEnabled(bl);
                jButton.setEnabled(!bl);
                jButton2.setEnabled(bl);
            }
        };
        if (!Utils.isWindows()) {
            radioOption.getComponent().setEnabled(false);
            jTextField.setEnabled(false);
            jButton.setEnabled(false);
        }
        jTextField.setPreferredSize(new Dimension(300, jTextField.getPreferredSize().height));
        JButtonGroup jButtonGroup = new JButtonGroup();
        jButtonGroup.add(radioOption.getComponent());
        jButtonGroup.add(radioOption2.getComponent());
        JLabel jLabel = Swinger.getLabel("settings.filePathTIConnect");
        jLabel.setLabelFor(jTextField);
        JLabel jLabel2 = Swinger.getLabel("settings.filePathTiLP");
        jLabel2.setLabelFor(jTextFieldOption2.getComponent());
        JLabel jLabel3 = Swinger.getLabel("settings.TiLPParams");
        jLabel3.setLabelFor(jTextFieldOption3.getComponent());
        JLabel jLabel4 = Swinger.getLabel("settings.moreInfoParams");
        jLabel4.setToolTipText(Lng.getLabel("settings.moreInfoParams.hint"));
        jLabel4.setForeground(Color.BLUE);
        jLabel4.addMouseListener(new URLMouseClickAdapter("http://wordrider.net/documentation.html#params"));
        jLabel4.setFocusable(true);
        TableLayout tableLayout = new TableLayout(new double[]{20.0, -1.0, 2.0, -2.0, -2.0, 2.0}, new double[]{-2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0, -2.0});
        tableLayout.setVGap(2);
        this.setLayout(tableLayout);
        this.add((Component)radioOption.getComponent(), new CustomLayoutConstraints(0, 0, 4, 1));
        this.add((Component)jLabel, new CustomLayoutConstraints(1, 1));
        this.add((Component)jTextField, new CustomLayoutConstraints(1, 2));
        this.add((Component)jButton, new CustomLayoutConstraints(3, 2));
        this.add((Component)radioOption2.getComponent(), new CustomLayoutConstraints(0, 3, 4, 1));
        this.add((Component)jLabel2, new CustomLayoutConstraints(1, 4));
        this.add((Component)jTextFieldOption2.getComponent(), new CustomLayoutConstraints(1, 5));
        this.add((Component)jButton2, new CustomLayoutConstraints(3, 5));
        this.add((Component)jLabel3, new CustomLayoutConstraints(1, 6));
        this.add((Component)jTextFieldOption3.getComponent(), new CustomLayoutConstraints(1, 7));
        this.add((Component)jLabel4, new CustomLayoutConstraints(3, 7, 2, 1));
    }

    private static class SimpleFileFilter
    extends FileFilter {
        private String description;
        private String[] fileNames;

        public SimpleFileFilter(String[] stringArray, String string) {
            this.description = string;
            this.fileNames = stringArray;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            if (string != null) {
                for (int i = 0; i < this.fileNames.length; ++i) {
                    if (!string.equalsIgnoreCase(this.fileNames[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getFileNames() {
            return this.fileNames;
        }
    }

    private static class SelFileAction
    implements ActionListener {
        private JTextComponent field;
        private SimpleFileFilter filter;

        public SelFileAction(JTextComponent jTextComponent, SimpleFileFilter simpleFileFilter) {
            this.field = jTextComponent;
            this.filter = simpleFileFilter;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.showFileChooser();
        }

        private void showFileChooser() {
            int n;
            JFileChooser jFileChooser = new JFileChooser(this.field.getText());
            jFileChooser.setFileFilter(this.filter);
            jFileChooser.setDialogTitle(Lng.getLabel("settings.filechooser"));
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setApproveButtonText(Lng.getLabel("settings.filechooserBtnSelect"));
            jFileChooser.setApproveButtonMnemonic(Lng.getMnemonic("settings.filechooserBtnSelect"));
            jFileChooser.setAcceptAllFileFilterUsed(false);
            FileChooserUI fileChooserUI = jFileChooser.getUI();
            if (fileChooserUI instanceof BasicFileChooserUI) {
                ((BasicFileChooserUI)fileChooserUI).setFileName(this.filter.getFileNames()[0]);
            }
            if ((n = jFileChooser.showOpenDialog(MainApp.getInstance().getMainAppFrame())) == 0) {
                this.field.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
            Swinger.inputFocus(this.field);
        }
    }
}

