/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.dialogs.settings;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.wordrider.core.Lng;
import net.wordrider.dialogs.AppDialog;
import net.wordrider.dialogs.settings.AppearanceSettingsPanel;
import net.wordrider.dialogs.settings.ButtonPanel;
import net.wordrider.dialogs.settings.ColorSettingsPanel;
import net.wordrider.dialogs.settings.EditorSettingsPanel;
import net.wordrider.dialogs.settings.GeneralSettingsPanel;
import net.wordrider.dialogs.settings.IOptionsManager;
import net.wordrider.dialogs.settings.MiscSettingsPanel;
import net.wordrider.dialogs.settings.SelectablePanel;
import net.wordrider.dialogs.settings.SendMethodSettingsPanel;
import net.wordrider.dialogs.settings.SettingsPanel;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class SettingsDialog
extends AppDialog {
    private static final Dimension buttonDimension = new Dimension(145, 40);
    private ButtonPanel buttonPanel = null;
    private SelectablePanel selectablePanel;
    private static final int PANEL_COLORS = 0;
    private static final int PANEL_GENERAL = 1;
    private static final int PANEL_EDITOR = 2;
    private static final int PANEL_MISC = 3;
    private static final int PANEL_APPEARANCE = 4;
    private static final int PANEL_SENDMETHOD = 5;
    private JPanel panelGeneralSettings = null;
    private JPanel panelEditorSettings = null;
    private JPanel panelColorSettings = null;
    private JPanel panelMiscSettings = null;
    private JPanel panelSendMethod = null;
    private JPanel panelAppearanceSettings = null;
    private AbstractButton toolbarBtnColorPanel;
    private AbstractButton toolbarBtnGeneralPanel;
    private AbstractButton toolbarBtnEditorPanel;
    private AbstractButton toolbarBtnMiscPanel;
    private AbstractButton toolbarBtnSendMethodPanel;
    private AbstractButton toolbarBtnAppPanel;
    private static final Logger logger = Logger.getLogger(SettingsDialog.class.getName());

    public SettingsDialog(Frame frame) {
        this(frame, false);
    }

    public SettingsDialog(Frame frame, boolean bl) {
        super(frame, true);
        try {
            this.init(bl);
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
        this.pack();
        Swinger.centerDialog(frame, this);
        this.setModal(true);
        this.setTitle(Lng.getLabel("settings.title"));
        this.setDefaultCloseOperation(2);
        this.setVisible(true);
    }

    private static AbstractButton getButton(Action action) {
        JToggleButton jToggleButton = new JToggleButton(action);
        jToggleButton.setHorizontalAlignment(2);
        jToggleButton.setMinimumSize(buttonDimension);
        jToggleButton.setPreferredSize(buttonDimension);
        jToggleButton.setRolloverEnabled(true);
        jToggleButton.setSize(buttonDimension);
        jToggleButton.setFocusable(true);
        return jToggleButton;
    }

    protected final AbstractButton getCancelButton() {
        return this.getButtonPanel().getCancelButton();
    }

    protected final AbstractButton getOkButton() {
        return this.getButtonPanel().getOkButton();
    }

    private JToolBar getToolBar() {
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setLayout(new GridBagLayout());
        jToolBar.setPreferredSize(new Dimension(160, 285));
        jToolBar.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3), BorderFactory.createLineBorder(Color.BLACK, 1)), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        jToolBar.setFloatable(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.toolbarBtnColorPanel = SettingsDialog.getButton(new SelectSettingsClickAction(0, "settings.btn.colors", null));
        buttonGroup.add(this.toolbarBtnColorPanel);
        this.toolbarBtnGeneralPanel = SettingsDialog.getButton(new SelectSettingsClickAction(1, "settings.btn.general", null));
        buttonGroup.add(this.toolbarBtnGeneralPanel);
        this.toolbarBtnEditorPanel = SettingsDialog.getButton(new SelectSettingsClickAction(2, "settings.btn.editor", null));
        buttonGroup.add(this.toolbarBtnEditorPanel);
        this.toolbarBtnSendMethodPanel = SettingsDialog.getButton(new SelectSettingsClickAction(5, "settings.btn.sendMethod", null));
        buttonGroup.add(this.toolbarBtnSendMethodPanel);
        this.toolbarBtnMiscPanel = SettingsDialog.getButton(new SelectSettingsClickAction(3, "settings.btn.misc", null));
        buttonGroup.add(this.toolbarBtnMiscPanel);
        this.toolbarBtnAppPanel = SettingsDialog.getButton(new SelectSettingsClickAction(4, "settings.btn.appearance", null));
        buttonGroup.add(this.toolbarBtnAppPanel);
        this.toolbarBtnGeneralPanel.setIcon(Swinger.getIcon("general.gif"));
        this.toolbarBtnEditorPanel.setIcon(Swinger.getIcon("editor.gif"));
        this.toolbarBtnSendMethodPanel.setIcon(Swinger.getIcon("sending_big.gif"));
        this.toolbarBtnColorPanel.setIcon(Swinger.getIcon("colors.gif"));
        this.toolbarBtnMiscPanel.setIcon(Swinger.getIcon("miscellanous.gif"));
        this.toolbarBtnAppPanel.setIcon(Swinger.getIcon("look-feel.gif"));
        jToolBar.add((Component)this.toolbarBtnGeneralPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        jToolBar.add((Component)this.toolbarBtnColorPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)this.toolbarBtnAppPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)this.toolbarBtnEditorPanel, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)this.toolbarBtnSendMethodPanel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add((Component)this.toolbarBtnMiscPanel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 11, 2, new Insets(4, 0, 0, 0), 0, 0));
        jToolBar.add(Box.createVerticalStrut(4), new GridBagConstraints(0, 5, 1, 1, 0.0, 1.0, 10, 1, new Insets(0, 0, 150, 0), 0, 0));
        return jToolBar;
    }

    public final ButtonPanel getButtonPanel() {
        return this.buttonPanel == null ? (this.buttonPanel = new ButtonPanel(this)) : this.buttonPanel;
    }

    private JPanel getColorSettingsPanel() {
        return this.panelColorSettings == null ? (this.panelColorSettings = new ColorSettingsPanel(this, Lng.getLabel("settings.colors.title"))) : this.panelColorSettings;
    }

    private JPanel getAppearanceSettingsPanel() {
        return this.panelAppearanceSettings == null ? (this.panelAppearanceSettings = new AppearanceSettingsPanel(this, Lng.getLabel("settings.appearance.title"))) : this.panelAppearanceSettings;
    }

    private JPanel getGeneralSettingsPanel() {
        return this.panelGeneralSettings == null ? (this.panelGeneralSettings = new GeneralSettingsPanel(this, Lng.getLabel("settings.general.title"))) : this.panelGeneralSettings;
    }

    private JPanel getEditorSettingsPanel() {
        return this.panelEditorSettings == null ? (this.panelEditorSettings = new EditorSettingsPanel(this, Lng.getLabel("settings.editor.title"))) : this.panelEditorSettings;
    }

    private JPanel getSendMethodPanelPanel() {
        return this.panelSendMethod == null ? (this.panelSendMethod = new SendMethodSettingsPanel(this, Lng.getLabel("settings.sendMethod.title"))) : this.panelSendMethod;
    }

    private JPanel getMiscSettingsPanel() {
        return this.panelMiscSettings == null ? (this.panelMiscSettings = new MiscSettingsPanel(this, Lng.getLabel("settings.misc.title"))) : this.panelMiscSettings;
    }

    private void init(boolean bl) {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.getToolBar(), "West");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.selectablePanel = new SelectablePanel();
        jPanel.add((Component)this.selectablePanel, "Center");
        jPanel.add((Component)this.getButtonPanel(), "South");
        container.add((Component)jPanel, "Center");
        if (!bl) {
            this.selectablePanel.showCard(this.getGeneralSettingsPanel());
            this.toolbarBtnGeneralPanel.setSelected(true);
        } else {
            this.selectablePanel.showCard(this.getSendMethodPanelPanel());
            this.toolbarBtnSendMethodPanel.setSelected(true);
            Swinger.inputFocus(this.toolbarBtnSendMethodPanel);
        }
    }

    public final SettingsPanel getActiveSettingsPanel() {
        return (SettingsPanel)this.selectablePanel.getActiveCard();
    }

    private void updateSize() {
        this.pack();
    }

    protected final void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 201) {
            this.getButtonPanel().getCancelButton().getAction().actionPerformed(null);
        }
    }

    private final class SelectSettingsClickAction
    extends AbstractAction {
        private final int actionCode;

        public SelectSettingsClickAction(int n, String string, String string2) {
            super(string);
            this.actionCode = n;
            this.putValue("Name", Lng.getLabel(string));
            this.putValue("MnemonicKey", new Integer(Lng.getMnemonic(string)));
            if (string2 != null) {
                this.putValue("SmallIcon", Swinger.getIcon(string2));
            }
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            IOptionsManager iOptionsManager = SettingsDialog.this.getActiveSettingsPanel().getOptionsManager();
            JFrame jFrame = (JFrame)SettingsDialog.this.getParent();
            if (iOptionsManager.wasChanged()) {
                int n = Swinger.getChoice(jFrame, Lng.getLabel("settings.confirm"));
                if (n == 0) {
                    iOptionsManager.applyChanges();
                } else {
                    iOptionsManager.restoreChanged();
                }
            }
            switch (this.actionCode) {
                case 1: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getGeneralSettingsPanel());
                    break;
                }
                case 0: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getColorSettingsPanel());
                    break;
                }
                case 4: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getAppearanceSettingsPanel());
                    break;
                }
                case 2: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getEditorSettingsPanel());
                    break;
                }
                case 5: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getSendMethodPanelPanel());
                    break;
                }
                case 3: {
                    SettingsDialog.this.selectablePanel.showCard(SettingsDialog.this.getMiscSettingsPanel());
                    break;
                }
                default: {
                    return;
                }
            }
            SettingsDialog.this.getActiveSettingsPanel().getOptionsManager().resetChanges();
            SettingsDialog.this.getActiveSettingsPanel().focusFirstComponent();
            SettingsDialog.this.updateSize();
        }
    }
}

