/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.plugintools;

import info.clearthought.layout.TableLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.wordrider.area.AlphaBetaKeyListener;
import net.wordrider.area.RiderEditorKit;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.Lng;
import net.wordrider.core.MainApp;
import net.wordrider.core.actions.RiderSwingWorker;
import net.wordrider.core.managers.AreaManager;
import net.wordrider.core.managers.FileChangeEvent;
import net.wordrider.core.managers.FileInstance;
import net.wordrider.core.managers.interfaces.IFileChangeListener;
import net.wordrider.core.managers.interfaces.IFileInstance;
import net.wordrider.core.swing.ColorPainterFactory;
import net.wordrider.core.swing.CustomLayoutConstraints;
import net.wordrider.core.swing.RecentsComboModel;
import net.wordrider.core.swing.SwingUtils;
import net.wordrider.plugintools.PluginTool;
import net.wordrider.utilities.LogUtils;
import net.wordrider.utilities.Swinger;

public final class FindAll
extends PluginTool
implements TreeSelectionListener,
IFileChangeListener {
    private JComboBox comboBox;
    private final JButton btnFindAll = Swinger.getButton("findall.btnFindAll");
    private final JToggleButton btnUnhighlight = Swinger.getToggleButton("findall.togglehighlight", false);
    private static final String PREFS_IGNORE_CASE = "findall_ignoreCase";
    private static final String PREFS_REGEXP = "findall_regexp";
    private static final String PREFS_HIGHLIGHT = "findall_highight";
    private static final String PREFS_INALLFILES = "findall_inAllFiles";
    private static final String PREFS_WHOLEWORDS = "findall_wholewords";
    private final JCheckBox checkIgnoreCase = Swinger.getCheckBox("findall.ignoreCase", "findall_ignoreCase", false);
    private final JCheckBox checkRegexp = Swinger.getCheckBox("findall.regexp", "findall_regexp", false);
    private final JCheckBox checkHighlight = Swinger.getCheckBox("findall.highlight", "findall_highight", true);
    private final JCheckBox checkInAllFiles = Swinger.getCheckBox("findall.inAllFiles", "findall_inAllFiles", true);
    private final JCheckBox checkWholeWords = Swinger.getCheckBox("findall.wholeWords", "findall_wholewords", false);
    private static final String PREFS_FINDALL = "findall_pref";
    private DefaultTreeModel treeModel = null;
    private DefaultMutableTreeNode rootNode = null;
    private JTree tree;
    private static final Logger logger = Logger.getLogger(FindAll.class.getName());
    private static final Highlighter.HighlightPainter underLinePainter = ColorPainterFactory.createJaggedUnderlinePainter(9);

    public FindAll() {
        try {
            Container container;
            MyCellRenderer myCellRenderer = new MyCellRenderer();
            myCellRenderer.setLeafIcon(null);
            this.rootNode = new DefaultMutableTreeNode();
            this.treeModel = new DefaultTreeModel(this.rootNode);
            this.tree = new JTree(this.treeModel);
            this.tree.setShowsRootHandles(false);
            this.tree.setCellRenderer(myCellRenderer);
            this.tree.setFont(RiderStyles.getAreaFont().deriveFont(10.0f));
            this.tree.getSelectionModel().setSelectionMode(1);
            this.tree.addTreeSelectionListener(this);
            this.tree.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        AreaManager.getInstance().grabActiveFocus();
                        mouseEvent.consume();
                    }
                }
            });
            ClickButtonListener clickButtonListener = new ClickButtonListener();
            this.btnFindAll.addActionListener(clickButtonListener);
            this.btnUnhighlight.addActionListener(clickButtonListener);
            this.checkRegexp.addActionListener(clickButtonListener);
            Swinger.SelectAllOnFocusListener selectAllOnFocusListener = new Swinger.SelectAllOnFocusListener();
            this.comboBox = new JComboBox(Swinger.loadSearchUsedList(PREFS_FINDALL));
            this.comboBox.setEditable(true);
            ActionKeyListener actionKeyListener = new ActionKeyListener();
            this.tree.addKeyListener(actionKeyListener);
            Component component = this.comboBox.getEditor().getEditorComponent();
            if (component instanceof JTextComponent) {
                container = (JTextComponent)component;
                ((JComponent)container).setFont(RiderStyles.getAreaFont());
                container.addKeyListener(actionKeyListener);
                ((JTextComponent)container).getDocument().addDocumentListener(new InputFieldsMethodListener());
                container.addFocusListener(selectAllOnFocusListener);
                Swinger.addKeyActions((JComponent)container);
            }
            this.comboBox.setPreferredSize(new Dimension(170, 23));
            container = this.getContentPane();
            container.setFocusCycleRoot(true);
            this.tree.setBorder(new EmptyBorder(2, 2, 2, 4));
            this.updateSearchingEnabled();
            this.updateUnhighlightEnabled(false);
            this.updateWholeWordsEnabled();
            TableLayout tableLayout = new TableLayout(new double[]{-2.0, -1.0}, new double[]{-2.0, -1.0, -2.0, -2.0, -2.0, -2.0, -2.0, 2.0, -2.0});
            tableLayout.setHGap(10);
            tableLayout.setVGap(2);
            container.setLayout(tableLayout);
            container.add((Component)this.comboBox, new CustomLayoutConstraints(0, 0, 2, 1));
            container.add((Component)new JScrollPane(this.tree), new CustomLayoutConstraints(0, 1, 2, 1));
            container.add((Component)this.checkRegexp, new CustomLayoutConstraints(0, 2, 2, 1));
            container.add((Component)this.checkIgnoreCase, new CustomLayoutConstraints(0, 3, 2, 1));
            container.add((Component)this.checkWholeWords, new CustomLayoutConstraints(0, 4, 2, 1));
            container.add((Component)this.checkHighlight, new CustomLayoutConstraints(0, 5, 2, 1));
            container.add((Component)this.checkInAllFiles, new CustomLayoutConstraints(0, 6, 2, 1));
            container.add((Component)this.btnFindAll, new CustomLayoutConstraints(1, 8, 1, 1, 3, 1));
            container.add((Component)this.btnUnhighlight, new CustomLayoutConstraints(0, 8, 1, 1, 0, 1));
            AreaManager.getInstance().addFileChangeListener(this);
            this.getComponent().setPreferredSize(new Dimension(280, 300));
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
        }
    }

    private void updateUnhighlightEnabled(boolean bl) {
        if (this.btnUnhighlight.isEnabled() != bl) {
            this.btnUnhighlight.setEnabled(bl);
        }
    }

    private void updateSearchingEnabled() {
        boolean bl;
        boolean bl2 = this.btnFindAll.isEnabled();
        boolean bl3 = bl = !Swinger.isEmpty(this.comboBox) && AreaManager.getInstance().getActiveInstance() != null;
        if (bl2 != bl) {
            this.btnFindAll.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearHistory(String string) {
        ((RecentsComboModel)this.comboBox.getModel()).addElement(string);
        Object object = this.tree.getTreeLock();
        synchronized (object) {
            for (int i = this.rootNode.getChildCount() - 1; i >= 0; --i) {
                FindAll.removeHighlights((DefaultMutableTreeNode)this.rootNode.getChildAt(i), true);
                this.rootNode.remove(i);
            }
            this.updateRootCount(-1, string);
            this.treeModel.reload();
        }
    }

    private static void removeHighlights(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        SearchResult searchResult = (SearchResult)defaultMutableTreeNode.getUserObject();
        if (searchResult.isHighlighted()) {
            Object c = searchResult.getFileInstance().getRiderArea();
            Highlighter highlighter = ((JTextComponent)c).getHighlighter();
            for (int i = defaultMutableTreeNode.getChildCount() - 1; i >= 0; --i) {
                SearchResultItem searchResultItem = (SearchResultItem)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                searchResultItem.unhighLight(highlighter);
                if (!bl) continue;
                defaultMutableTreeNode.remove(i);
            }
            if (!bl) {
                searchResult.setHighLighted(false);
                AreaManager.getInstance().repaintActive();
            }
        }
    }

    private void doFindAll() {
        GlobalSearch globalSearch = new GlobalSearch();
        globalSearch.init();
        globalSearch.get();
    }

    private void findAll() throws BadLocationException {
        Collection collection;
        String string = this.comboBox.getEditor().getItem().toString();
        if (string == null || string.length() == 0) {
            return;
        }
        boolean bl = this.checkRegexp.isSelected();
        boolean bl2 = this.checkIgnoreCase.isSelected();
        Pattern pattern = null;
        if (bl) {
            try {
                pattern = Pattern.compile(string, bl2 ? 74 : 72);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.getContentPane().getToolkit().beep();
                Swinger.showErrorDialog(MainApp.getInstance().getMainAppFrame(), SwingUtils.getMessage(patternSyntaxException, "Invalid regexp:", "near index"));
                Swinger.inputFocus(this.comboBox);
                return;
            }
        }
        this.clearHistory(string);
        if (this.checkInAllFiles.isSelected()) {
            collection = AreaManager.getInstance().getOpenedInstances();
        } else {
            collection = new ArrayList(1);
            collection.add(AreaManager.getInstance().getActiveInstance());
        }
        final String string2 = string;
        if (bl2 && !bl) {
            string = string.toLowerCase();
        }
        int n = string.length();
        int n2 = 0;
        int n3 = this.tree.getVisibleRect().height / this.tree.getRowBounds((int)0).height;
        boolean bl3 = this.checkWholeWords.isSelected();
        for (FileInstance fileInstance : collection) {
            IFileInstance iFileInstance = fileInstance;
            Object c = iFileInstance.getRiderArea();
            Document document = ((JTextComponent)c).getDocument();
            int n4 = document.getLength();
            String string3 = document.getText(0, n4);
            if (bl2 && !bl) {
                string3 = string3.toLowerCase();
            }
            DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
            int n5 = 0;
            if (!bl) {
                int n6;
                int n7 = 0;
                while ((n6 = string3.indexOf(string, n7)) != -1) {
                    n7 = n6 + n;
                    if (bl3 && (!bl3 || !FindAll.wholeWordsCheck(n6, n7, string3, n4))) continue;
                    ++n5;
                    this.addSearchResult(iFileInstance, (JTextComponent)c, document, defaultMutableTreeNode, n6, n7, string2);
                }
            } else {
                Matcher matcher = pattern.matcher(string3);
                while (matcher.find()) {
                    ++n5;
                    this.addSearchResult(iFileInstance, (JTextComponent)c, document, defaultMutableTreeNode, matcher.start(), matcher.end(), matcher.group());
                }
            }
            if (n5 != 0) {
                SearchResult searchResult = (SearchResult)defaultMutableTreeNode.getUserObject();
                searchResult.updateFoundCount(n5);
                this.treeModel.valueForPathChanged(new TreePath(defaultMutableTreeNode.getPath()), searchResult);
                if (this.rootNode.getChildCount() <= 1 || n2 < n3) {
                    this.tree.expandPath(new TreePath(this.treeModel.getPathToRoot(defaultMutableTreeNode)));
                }
                if (this.checkHighlight.isSelected() && ((Component)c).isVisible()) {
                    AreaManager.getInstance().repaintActive();
                }
            }
            n2 += n5;
        }
        final int n8 = n2;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    if (n8 > 0) {
                        TreeNode treeNode = FindAll.this.rootNode.getChildAt(0);
                        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeNode.getChildAt(0);
                        FindAll.this.tree.setSelectionPath(new TreePath(defaultMutableTreeNode.getPath()));
                    }
                    FindAll.this.updateRootCount(n8, string2);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private static boolean wholeWordsCheck(int n, int n2, String string, int n3) {
        return !(n != 0 && !RiderEditorKit.WORD_SEPARATORS.get(string.charAt(n - 1)) || n2 != n3 && !RiderEditorKit.WORD_SEPARATORS.get(string.charAt(n2)));
    }

    private void updateRootCount(int n, String string) {
        String string2 = Lng.getLabel("findall.rootInfo", new Object[]{string, n < 0 ? "" : "{" + n + "}"});
        this.treeModel.valueForPathChanged(new TreePath(this.rootNode), string2);
    }

    private void addSearchResult(IFileInstance iFileInstance, JTextComponent jTextComponent, Document document, final DefaultMutableTreeNode defaultMutableTreeNode, int n, int n2, String string) throws BadLocationException {
        int n3 = Utilities.getRowStart(jTextComponent, n);
        int n4 = Utilities.getRowEnd(jTextComponent, n2);
        String string2 = n3 < n ? document.getText(n3, n - n3) : "";
        String string3 = n4 > n2 ? document.getText(n2, n4 - n2) : "";
        SearchResultItem searchResultItem = new SearchResultItem(n, n2, string2, string, string3);
        if (this.checkHighlight.isSelected()) {
            searchResultItem.highLight(jTextComponent.getHighlighter());
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(searchResultItem, false);
        int n5 = defaultMutableTreeNode.getChildCount();
        if (n5 == 0) {
            defaultMutableTreeNode.setUserObject(new SearchResult(iFileInstance, this.checkHighlight.isSelected()));
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = FindAll.this.tree.getTreeLock();
                    synchronized (object) {
                        FindAll.this.treeModel.insertNodeInto(defaultMutableTreeNode, FindAll.this.rootNode, FindAll.this.rootNode.getChildCount());
                    }
                }
            });
        }
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n5);
    }

    public final String getName() {
        return Lng.getLabel("findall.title");
    }

    public String getTabName() {
        return this.getName();
    }

    public final Icon getIcon() {
        return Swinger.getIcon("find.gif");
    }

    public final String getTip() {
        return Lng.getLabel("findall.tooltip");
    }

    public void activate() {
        Swinger.inputFocus(this.comboBox);
        logger.info("FindAll activated");
    }

    public void deactivate() {
        logger.info("FindAll deactivated");
    }

    public void updateData() {
    }

    public void fileWasOpened(FileChangeEvent fileChangeEvent) {
        this.updateSearchingEnabled();
    }

    public void fileWasClosed(FileChangeEvent fileChangeEvent) {
        IFileInstance iFileInstance = fileChangeEvent.getFileInstance();
        for (int i = this.rootNode.getChildCount() - 1; i >= 0; --i) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.rootNode.getChildAt(i);
            if (!((SearchResult)defaultMutableTreeNode.getUserObject()).getFileInstance().equals(iFileInstance)) continue;
            FindAll.removeHighlights(defaultMutableTreeNode, true);
            defaultMutableTreeNode.removeAllChildren();
            this.rootNode.remove(i);
            this.treeModel.reload();
            boolean bl = this.rootNode.getChildCount() > 0;
            this.updateUnhighlightEnabled(bl);
            if (bl) break;
            this.treeModel.valueForPathChanged(new TreePath(this.rootNode), null);
            break;
        }
        this.updateSearchingEnabled();
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            return;
        }
        if (defaultMutableTreeNode.isLeaf()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
            if (defaultMutableTreeNode2 == null) {
                return;
            }
            IFileInstance iFileInstance = ((SearchResult)defaultMutableTreeNode2.getUserObject()).getFileInstance();
            Object c = iFileInstance.getRiderArea();
            SwingUtilities.invokeLater(new Runnable((JTextComponent)c, iFileInstance){
                final /* synthetic */ JTextComponent val$textComponent;
                final /* synthetic */ IFileInstance val$fileInstance;
                {
                    this.val$textComponent = jTextComponent;
                    this.val$fileInstance = iFileInstance;
                }

                public void run() {
                    ((SearchResultItem)defaultMutableTreeNode.getUserObject()).selectResult(this.val$textComponent);
                    AreaManager.getInstance().activateInstance(this.val$fileInstance);
                }
            });
        }
    }

    public boolean closeSoft() {
        AppPrefs.storeProperty(PREFS_HIGHLIGHT, this.checkHighlight.isSelected());
        AppPrefs.storeProperty(PREFS_IGNORE_CASE, this.checkIgnoreCase.isSelected());
        AppPrefs.storeProperty(PREFS_INALLFILES, this.checkInAllFiles.isSelected());
        AppPrefs.storeProperty(PREFS_REGEXP, this.checkRegexp.isSelected());
        AppPrefs.storeProperty(PREFS_WHOLEWORDS, this.checkWholeWords.isSelected());
        Swinger.storeProperties(PREFS_FINDALL, this.comboBox);
        return true;
    }

    public void closeHard() {
    }

    private void updateWholeWordsEnabled() {
        this.checkWholeWords.setEnabled(!this.checkRegexp.isSelected());
    }

    private static void addHighlights(DefaultMutableTreeNode defaultMutableTreeNode) {
        SearchResult searchResult = (SearchResult)defaultMutableTreeNode.getUserObject();
        if (!searchResult.isHighlighted()) {
            Object c = searchResult.getFileInstance().getRiderArea();
            Highlighter highlighter = ((JTextComponent)c).getHighlighter();
            for (int i = defaultMutableTreeNode.getChildCount() - 1; i >= 0; --i) {
                SearchResultItem searchResultItem = (SearchResultItem)((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i)).getUserObject();
                searchResultItem.highLight(highlighter);
            }
            AreaManager.getInstance().repaintActive();
        }
        searchResult.setHighLighted(true);
    }

    private final class ClickButtonListener
    implements ActionListener {
        private ClickButtonListener() {
        }

        public final void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object.equals(FindAll.this.btnFindAll) && FindAll.this.btnFindAll.isEnabled()) {
                FindAll.this.doFindAll();
            } else if (object.equals(FindAll.this.btnUnhighlight)) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (!FindAll.this.btnUnhighlight.isSelected()) {
                            for (int i = FindAll.this.rootNode.getChildCount() - 1; i >= 0; --i) {
                                FindAll.removeHighlights((DefaultMutableTreeNode)FindAll.this.rootNode.getChildAt(i), false);
                            }
                        } else {
                            for (int i = FindAll.this.rootNode.getChildCount() - 1; i >= 0; --i) {
                                FindAll.addHighlights((DefaultMutableTreeNode)FindAll.this.rootNode.getChildAt(i));
                            }
                        }
                    }
                });
            } else {
                FindAll.this.updateWholeWordsEnabled();
            }
        }
    }

    private static final class SearchResultItem {
        private String searchString;
        private final int foundStart;
        private final int foundEnd;
        private Object highlightTag = null;

        public SearchResultItem(int n, int n2, String string, String string2, String string3) {
            this.foundStart = n;
            this.foundEnd = n2;
            this.updateSearchString(string, string2, string3);
        }

        private void updateSearchString(String string, String string2, String string3) {
            this.searchString = Lng.getLabel("findall.usageLeaf", new Object[]{string, string2, string3});
        }

        public final void highLight(Highlighter highlighter) {
            try {
                this.highlightTag = highlighter.addHighlight(this.foundStart, this.foundEnd, underLinePainter);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
            }
        }

        public final void unhighLight(Highlighter highlighter) {
            if (this.highlightTag != null) {
                highlighter.removeHighlight(this.highlightTag);
                this.highlightTag = null;
            }
        }

        public final void selectResult(JTextComponent jTextComponent) {
            Rectangle rectangle;
            try {
                rectangle = jTextComponent.modelToView(this.foundStart);
            }
            catch (BadLocationException badLocationException) {
                LogUtils.processException(logger, badLocationException);
                return;
            }
            if (rectangle == null) {
                return;
            }
            rectangle.y += -20;
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
            rectangle.height = jTextComponent.getVisibleRect().height;
            try {
                jTextComponent.setCaretPosition(this.foundStart);
                jTextComponent.moveCaretPosition(this.foundEnd);
            }
            catch (Exception exception) {
                return;
            }
            jTextComponent.scrollRectToVisible(rectangle);
        }

        public final String toString() {
            return this.searchString;
        }
    }

    private static final class SearchResult {
        private final IFileInstance fileInstance;
        private String searchString;
        private boolean isHighlighted;

        public SearchResult(IFileInstance iFileInstance, boolean bl) {
            this.fileInstance = iFileInstance;
            this.updateFoundCount(-1);
            this.isHighlighted = bl;
        }

        public final IFileInstance getFileInstance() {
            return this.fileInstance;
        }

        public final void updateFoundCount(int n) {
            this.searchString = Lng.getLabel("findall.usagesNode", new Object[]{this.fileInstance.getName(), n < 0 ? "" : "{" + n + "}"});
        }

        public final boolean isHighlighted() {
            return this.isHighlighted;
        }

        public final void setHighLighted(boolean bl) {
            this.isHighlighted = bl;
        }

        public final String toString() {
            return this.searchString;
        }
    }

    private static final class MyCellRenderer
    extends DefaultTreeCellRenderer {
        private MyCellRenderer() {
        }

        public final Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (dimension != null) {
                dimension.width += 5;
            }
            return dimension;
        }
    }

    private final class ActionKeyListener
    extends AlphaBetaKeyListener {
        private ActionKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            boolean bl2 = bl = keyEvent.getKeyCode() == 10;
            if (keyEvent.getSource() instanceof JTextComponent) {
                if (bl) {
                    keyEvent.consume();
                    if (FindAll.this.btnFindAll.isEnabled()) {
                        FindAll.this.btnFindAll.doClick();
                    } else {
                        FindAll.this.btnFindAll.getToolkit().beep();
                    }
                } else {
                    super.keyPressed(keyEvent);
                }
            } else if (bl) {
                AreaManager.getInstance().grabActiveFocus();
                keyEvent.consume();
            }
        }
    }

    private final class GlobalSearch
    extends RiderSwingWorker {
        public GlobalSearch() {
            super(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final Object construct() {
            JProgressBar jProgressBar = this.dialogToClose.getProgressBar();
            jProgressBar.setIndeterminate(true);
            jProgressBar.setStringPainted(true);
            this.showInfoWhileLoading("findall.msgSearching");
            boolean bl = FindAll.this.btnFindAll.isFocusOwner();
            if (bl) {
                FindAll.this.tree.grabFocus();
                FindAll.this.tree.requestFocus();
            }
            FindAll.this.btnFindAll.setEnabled(false);
            FindAll.this.updateUnhighlightEnabled(false);
            FindAll.this.btnUnhighlight.setSelected(false);
            FindAll.this.tree.setCursor(Cursor.getPredefinedCursor(3));
            try {
                try {
                    FindAll.this.findAll();
                }
                catch (BadLocationException badLocationException) {
                    LogUtils.processException(logger, badLocationException);
                    Object var5_4 = null;
                    FindAll.this.tree.setCursor(Cursor.getPredefinedCursor(0));
                    FindAll.this.btnFindAll.setEnabled(true);
                    boolean bl4 = FindAll.this.rootNode.getChildCount() > 0;
                    FindAll.this.updateUnhighlightEnabled(bl4);
                    FindAll.this.btnUnhighlight.setSelected(bl4 && FindAll.this.checkHighlight.isSelected());
                    if (bl4) return null;
                    FindAll.this.btnFindAll.getToolkit().beep();
                    return null;
                }
                Object var5_3 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                FindAll.this.tree.setCursor(Cursor.getPredefinedCursor(0));
                FindAll.this.btnFindAll.setEnabled(true);
                boolean bl2 = FindAll.this.rootNode.getChildCount() > 0;
                FindAll.this.updateUnhighlightEnabled(bl2);
                FindAll.this.btnUnhighlight.setSelected(bl2 && FindAll.this.checkHighlight.isSelected());
                if (bl2) throw throwable;
                FindAll.this.btnFindAll.getToolkit().beep();
                throw throwable;
            }
            FindAll.this.tree.setCursor(Cursor.getPredefinedCursor(0));
            FindAll.this.btnFindAll.setEnabled(true);
            boolean bl3 = FindAll.this.rootNode.getChildCount() > 0;
            FindAll.this.updateUnhighlightEnabled(bl3);
            FindAll.this.btnUnhighlight.setSelected(bl3 && FindAll.this.checkHighlight.isSelected());
            if (bl3) return null;
            FindAll.this.btnFindAll.getToolkit().beep();
            return null;
        }
    }

    private final class InputFieldsMethodListener
    implements DocumentListener {
        private InputFieldsMethodListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            FindAll.this.updateSearchingEnabled();
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            FindAll.this.updateSearchingEnabled();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            FindAll.this.updateSearchingEnabled();
        }
    }
}

