/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import net.wordrider.area.RiderStyles;
import net.wordrider.core.AppPrefs;
import net.wordrider.core.swing.ColorPainterFactory;

final class BracketMatcher {
    private static final String BRACKET_HIGHLIGHT_PROPERTY = "bracketMatcher";
    private static final String PAINTER_TAGS_PROPERTY = "bracketMatcherTags";
    private static final Highlighter.HighlightPainter goodPainter = ColorPainterFactory.createColorPainter(6);
    private static final Highlighter.HighlightPainter badPainter = ColorPainterFactory.createColorPainter(7);
    private static final CaretListener caretListener = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            BracketMatcher.caretUpdate(caretEvent);
        }
    };

    private BracketMatcher() {
    }

    public static void install(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(BRACKET_HIGHLIGHT_PROPERTY) == null) {
            jTextComponent.putClientProperty(BRACKET_HIGHLIGHT_PROPERTY, BRACKET_HIGHLIGHT_PROPERTY);
            jTextComponent.putClientProperty(PAINTER_TAGS_PROPERTY, new PainterTags());
            jTextComponent.addCaretListener(caretListener);
        }
    }

    public static void uninstall(JTextComponent jTextComponent) {
        if (jTextComponent.getClientProperty(BRACKET_HIGHLIGHT_PROPERTY) != null) {
            PainterTags painterTags = (PainterTags)jTextComponent.getClientProperty(PAINTER_TAGS_PROPERTY);
            painterTags.clearHighlights();
            jTextComponent.putClientProperty(BRACKET_HIGHLIGHT_PROPERTY, null);
            jTextComponent.putClientProperty(PAINTER_TAGS_PROPERTY, null);
            jTextComponent.removeCaretListener(caretListener);
        }
    }

    private static char getCharAt(Document document, int n) throws BadLocationException {
        return document.getText(n, 1).charAt(0);
    }

    private static int findMatchingParenBack(Document document, int n, int n2) throws BadLocationException {
        int n3;
        int n4 = 1;
        for (n3 = n - 1; n3 >= n2; --n3) {
            char c = BracketMatcher.getCharAt(document, n3);
            switch (c) {
                case ')': 
                case ']': 
                case '}': {
                    ++n4;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    --n4;
                }
            }
            if (n4 == 0) break;
        }
        return n3;
    }

    private static int findMatchingParenForward(Document document, int n, int n2) throws BadLocationException {
        int n3;
        int n4 = 1;
        for (n3 = n + 1; n3 < n2; ++n3) {
            char c = BracketMatcher.getCharAt(document, n3);
            switch (c) {
                case ')': 
                case ']': 
                case '}': {
                    --n4;
                    break;
                }
                case '(': 
                case '[': 
                case '{': {
                    ++n4;
                }
            }
            if (n4 == 0) break;
        }
        return n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void caretUpdate(CaretEvent caretEvent) {
        int n;
        int n2;
        int n3;
        int n4;
        JTextComponent jTextComponent = (JTextComponent)caretEvent.getSource();
        PainterTags painterTags = (PainterTags)jTextComponent.getClientProperty(PAINTER_TAGS_PROPERTY);
        painterTags.clearHighlights();
        int n5 = caretEvent.getDot();
        Document document = jTextComponent.getDocument();
        if (AppPrefs.getProperty("settings.matchbracketmath", true)) {
            Element element = Utilities.getParagraphElement(jTextComponent, n5);
            if (!RiderStyles.isMath(element)) return;
            n4 = element.getStartOffset();
            n3 = element.getEndOffset();
        } else {
            n4 = 0;
            n3 = document.getLength();
        }
        painterTags.highlighter = jTextComponent.getHighlighter();
        if (n5 != n4) {
            int n6 = n5 - 1;
            try {
                n2 = BracketMatcher.getCharAt(document, n6);
                if (n2 == 41 || n2 == 93 || n2 == 125) {
                    n = BracketMatcher.findMatchingParenBack(document, n6, n4);
                    if (n >= n4) {
                        char c = BracketMatcher.getCharAt(document, n);
                        Highlighter.HighlightPainter highlightPainter = c == '(' && n2 == 41 || c == '{' && n2 == 125 || c == '[' && n2 == 93 ? goodPainter : badPainter;
                        painterTags.start1 = painterTags.addHighlighter(n, highlightPainter);
                        painterTags.end1 = painterTags.addHighlighter(n6, highlightPainter);
                    } else {
                        painterTags.end1 = painterTags.addHighlighter(n6, BracketMatcher.badPainter);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (n5 >= n3) return;
        try {
            char c = BracketMatcher.getCharAt(document, n5);
            if (c != '(' && c != '[' && c != '{') return;
            n2 = BracketMatcher.findMatchingParenForward(document, n5, n3);
            if (n2 < n3) {
                n = BracketMatcher.getCharAt(document, n2);
                Highlighter.HighlightPainter highlightPainter = c == '(' && n == 41 || c == '{' && n == 125 || c == '[' && n == 93 ? goodPainter : badPainter;
                painterTags.start2 = painterTags.addHighlighter(n5, highlightPainter);
                painterTags.end2 = painterTags.addHighlighter(n2, highlightPainter);
                return;
            } else {
                painterTags.end2 = painterTags.addHighlighter(n5, BracketMatcher.badPainter);
            }
            return;
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private static final class PainterTags {
        Highlighter highlighter = null;
        Object start1 = null;
        Object end1 = null;
        Object start2 = null;
        Object end2 = null;

        private PainterTags() {
        }

        private void clearHighlights() {
            if (this.highlighter != null) {
                if (this.start1 != null) {
                    this.highlighter.removeHighlight(this.start1);
                }
                if (this.end1 != null) {
                    this.highlighter.removeHighlight(this.end1);
                }
                if (this.start2 != null) {
                    this.highlighter.removeHighlight(this.start2);
                }
                if (this.end2 != null) {
                    this.highlighter.removeHighlight(this.end2);
                }
                this.end1 = null;
                this.start1 = null;
                this.end2 = null;
                this.start2 = null;
                this.highlighter = null;
            }
        }

        private Object addHighlighter(int n, Highlighter.HighlightPainter highlightPainter) throws BadLocationException {
            return this.highlighter.addHighlight(n, n + 1, highlightPainter);
        }
    }
}

