/*
 * Decompiled with CFR 0.152.
 */
package net.wordrider.area;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import net.wordrider.area.ColorStyles;

final class SeparatorLine
extends JComponent {
    public static final int SINGLE_LINE = 0;
    public static final int DOUBLE_LINE = 1;
    private int lineType = 0;
    private JTextComponent pane = null;
    private static final Stroke stroke = new BasicStroke(1.0f);
    private boolean wasSelected;

    private SeparatorLine(JTextComponent jTextComponent) {
        this.pane = jTextComponent;
        this.addHierarchyListener(new MyHierarchyListener(this, jTextComponent));
    }

    public final int getLineType() {
        return this.lineType;
    }

    public final Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public final int getWidth() {
        Insets insets = this.pane.getInsets();
        return (int)this.pane.getVisibleRect().getWidth() - insets.left - insets.right - 2;
    }

    public boolean contains(int n, int n2) {
        int n3;
        int n4 = this.getWidth();
        if ((n4 | (n3 = this.getHeight())) < 0) {
            return false;
        }
        int n5 = this.getX();
        int n6 = this.getY() + 6;
        if (n < n5 || n2 < n6) {
            return false;
        }
        n3 += n6;
        return !((n4 += n5) >= n5 && n4 <= n || n3 >= n6 && n3 <= n2);
    }

    public SeparatorLine(JTextComponent jTextComponent, int n) {
        this(jTextComponent);
        this.lineType = n;
    }

    public final Dimension getMinimumSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public final void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setPaintMode();
        if (((Boolean)this.getClientProperty("selected")).booleanValue()) {
            graphics.setColor(this.pane.getSelectionColor());
            graphics.fillRect(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY() + 6);
            this.wasSelected = true;
            graphics.setColor(Color.BLACK);
        } else {
            if (this.wasSelected) {
                this.repaint();
                this.wasSelected = false;
                return;
            }
            graphics.setColor(ColorStyles.getColor(3));
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(stroke);
        if (this.lineType == 0) {
            graphics.drawRect(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY());
        } else {
            graphics.drawLine(this.getX(), this.getY(), this.getX() + this.getWidth(), this.getY());
            graphics.drawLine(this.getX(), this.getY() + 2, this.getX() + this.getWidth(), this.getY() + 2);
        }
    }

    public final int getHeight() {
        return 8;
    }

    public final String toString() {
        return SeparatorLine.getStringRepresentation(this.lineType);
    }

    public static String getStringRepresentation(int n) {
        return n == 0 ? "&-" : "&=";
    }

    public final class MyHierarchyListener
    implements HierarchyListener {
        private Container oldParent;
        private final Component comp;
        private final JTextComponent pane;

        public MyHierarchyListener(Component component, JTextComponent jTextComponent) {
            this.comp = component;
            this.pane = jTextComponent;
        }

        public final void hierarchyChanged(HierarchyEvent hierarchyEvent) {
            Container container = this.comp.getParent();
            if (container != this.oldParent) {
                if (this.oldParent != null) {
                    this.pane.remove(this.oldParent);
                }
                this.oldParent = container;
            }
        }
    }
}

